/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.infrastructure.persistence.repository;

import br.pucrio.tecgraf.soma.job.domain.model.Job;
import br.pucrio.tecgraf.soma.job.infrastructure.persistence.repository.JobGroupValCount;
import br.pucrio.tecgraf.soma.job.infrastructure.persistence.specification.GroupsInListSpecification;
import br.pucrio.tecgraf.soma.serviceapi.persistence.repository.Sort;
import br.pucrio.tecgraf.soma.serviceapi.persistence.repository.impl.JPARepository;
import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.JPASpecification;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Repository
public class JobRepository
extends JPARepository<Job> {
    @PersistenceContext
    private EntityManager _entityManager;

    public Class<Job> getType() {
        return Job.class;
    }

    public EntityManager getEntityManager() {
        return this._entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this._entityManager = entityManager;
    }

    public List<Job> getJobs(Collection<Long> ids, Sort ... sorts) {
        EntityManager manager = this.getEntityManager();
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Job.class);
        Root root = criteria.from(Job.class);
        root.alias("getJobs");
        criteria.where((Expression)root.get("id").in(ids)).orderBy(this.createSorting(builder, root, sorts));
        return manager.createQuery(criteria).getResultList();
    }

    public List<String> findNotSingletonGroupIds(List<String> ids) {
        EntityManager manager = this.getEntityManager();
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(String.class);
        Root root = criteria.from(Job.class);
        root.alias("findNotSingletonGroupIds");
        Path groupId = root.get("groupId");
        GroupsInListSpecification specification = new GroupsInListSpecification(ids);
        criteria.select((Selection)groupId).where((Expression)specification.toPredicate(root, builder)).having((Expression)builder.greaterThan(builder.countDistinct((Expression)root.get("id")), (Comparable)Long.valueOf(1L))).groupBy(new Expression[]{groupId});
        return manager.createQuery(criteria).getResultList();
    }

    public List<Long> findJobIds(JPASpecification<Job> specification, int maxResult, int offset, Sort ... sorts) {
        EntityManager manager = this.getEntityManager();
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Long.class);
        Root root = criteria.from(Job.class);
        root.alias("findJobIds");
        Predicate predicate = specification.toPredicate(root, builder);
        criteria.select((Selection)root.get("id")).where((Expression)predicate).orderBy(this.createSorting(builder, root, sorts));
        TypedQuery query = manager.createQuery(criteria);
        query.setMaxResults(maxResult);
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        return query.getResultList();
    }

    public long countGroups(JPASpecification<Job> specification) {
        CriteriaBuilder builder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Long.class);
        Root jobRoot = criteria.from(Job.class);
        jobRoot.alias("countGroups");
        criteria.select((Selection)builder.countDistinct((Expression)jobRoot.get("groupId"))).where((Expression)specification.toPredicate(jobRoot, builder));
        return (Long)this.getEntityManager().createQuery(criteria).getSingleResult();
    }

    public long countJobs(JPASpecification<Job> specification) {
        CriteriaBuilder builder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Long.class);
        Root jobRoot = criteria.from(Job.class);
        jobRoot.alias("countJobs");
        criteria.select((Selection)builder.countDistinct((Expression)jobRoot.get("id"))).where((Expression)specification.toPredicate(jobRoot, builder));
        return (Long)this.getEntityManager().createQuery(criteria).getSingleResult();
    }

    public List<String> findGroupIdsWithDescriptionVariation(List<String> groupIds) {
        String hql = "    SELECT j.groupId\n    FROM Job j\n    WHERE j.groupId IN :groupIds\n    GROUP BY j.groupId\n    HAVING COUNT(DISTINCT function('md5', j.description)) > 1\n";
        return this.getEntityManager().createQuery(hql, String.class).setParameter("groupIds", groupIds).getResultList();
    }

    public List<JobGroupValCount> findGroupedJobs(JPASpecification<Job> specification, int maxResult, int offset, Sort ... sorts) {
        CriteriaBuilder builder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery grpCriteria = builder.createQuery(JobGroupValCount.class);
        Root jobRoot = grpCriteria.from(Job.class);
        jobRoot.alias("findGroupedJobs");
        Path jobId = jobRoot.get("id");
        Path jobGrpId = jobRoot.get("groupId");
        grpCriteria.select((Selection)builder.construct(JobGroupValCount.class, new Selection[]{jobGrpId, builder.min((Expression)jobId), builder.count((Expression)jobId), builder.countDistinct((Expression)jobRoot.get("projectId")), builder.countDistinct((Expression)jobRoot.get("jobOwner")), builder.countDistinct((Expression)jobRoot.get("automaticallyMachineSelection")), builder.countDistinct((Expression)jobRoot.get("numberOfProcesses")), builder.countDistinct((Expression)jobRoot.get("numberOfProcessesByMachine")), builder.countDistinct((Expression)jobRoot.get("priority")), builder.countDistinct((Expression)jobRoot.get("multipleExecution")), builder.countDistinct((Expression)jobRoot.get("jobType")), builder.countDistinct((Expression)jobRoot.get("executionMachine")), builder.countDistinct((Expression)jobRoot.get("exitCode")), builder.countDistinct((Expression)jobRoot.get("guiltyNodeId")), builder.countDistinct((Expression)jobRoot.get("exitStatus")), builder.countDistinct((Expression)jobRoot.get("flowId")), builder.countDistinct((Expression)jobRoot.get("flowVersion")), builder.countDistinct((Expression)jobRoot.get("flowName")), builder.min((Expression)jobRoot.get("submissionTime")), builder.max((Expression)jobRoot.get("lastModifiedTime"))})).where((Expression)specification.toPredicate(jobRoot, builder)).groupBy(new Expression[]{jobGrpId}).orderBy(this.createGroupSorting(builder, jobRoot, sorts));
        TypedQuery grpQuery = this.getEntityManager().createQuery(grpCriteria);
        grpQuery.setMaxResults(maxResult);
        if (offset > 0) {
            grpQuery.setFirstResult(offset);
        }
        return grpQuery.getResultList();
    }

    private <T> List<Order> createSorting(CriteriaBuilder builder, Root<T> root, Sort ... sorts) {
        ArrayList<Order> sorting = new ArrayList<Order>();
        for (Sort sort : sorts) {
            if (sort.isAscending()) {
                sorting.add(builder.asc((Expression)root.get(sort.getAttribute())));
                continue;
            }
            sorting.add(builder.desc((Expression)root.get(sort.getAttribute())));
        }
        return sorting;
    }

    private <T> List<Order> createGroupSorting(CriteriaBuilder builder, Root<T> root, Sort ... sorts) {
        ArrayList<Order> sorting = new ArrayList<Order>();
        for (Sort sort : sorts) {
            if (sort.isAscending()) {
                sorting.add(builder.asc(builder.min((Expression)root.get(sort.getAttribute()))));
                continue;
            }
            sorting.add(builder.desc(builder.max((Expression)root.get(sort.getAttribute()))));
        }
        return sorting;
    }
}

