package br.pucrio.tecgraf.soma.job.log.monitor.event;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Objects;

public class FileChunk {

  private Path path;
  private String data;
  private Integer length;
  private Long fileLength;
  private Long offset;
  private Charset fileEncoding;

  public FileChunk(
      Path path, String data, Integer length, Long fileLength, Long offset, Charset fileEncoding) {
    this.path = path;
    this.data = data;
    this.length = length;
    this.fileLength = fileLength;
    this.offset = offset;
    this.fileEncoding = fileEncoding;
  }

  public Path getPath() {
    return path;
  }

  public String getData() {
    return data;
  }

  public Integer getLength() {
    return length;
  }

  public Long getFileLength() {
    return fileLength;
  }

  public Long getOffset() {
    return offset;
  }

  public Charset getFileEncoding() {
    return fileEncoding;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    FileChunk fileChunk = (FileChunk) o;
    return path.equals(fileChunk.path)
        && data.equals(fileChunk.data)
        && length.equals(fileChunk.length)
        && fileLength.equals(fileChunk.fileLength)
        && offset.equals(fileChunk.offset)
        && fileEncoding.equals(fileChunk.fileEncoding);
  }

  @Override
  public int hashCode() {
    return Objects.hash(path, data, length, fileLength, offset, fileEncoding);
  }
}
