package br.pucrio.tecgraf.soma.job.log.watcher.interfaces;

import java.io.FileFilter;
import java.io.IOException;

/** A file watcher that notify when receive files modifications or removal. */
public interface IFileWatcher extends IWatcher {

  void register(final String dirStrPath, final FileFilter filter) throws IOException;

  void startWatch() throws InterruptedException;

  void stopWatch() throws Exception;

  void addFileWatchEventListener(IFileWatchEventListener listener);

  void removeFileWatchEventListener(IFileWatchEventListener listener);

  boolean isWatching();
}
