package br.pucrio.tecgraf.soma.logsmonitor.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Objects;

@Getter
@Setter
@EqualsAndHashCode(onlyExplicitlyIncluded = true, callSuper = false)
@ToString
@JsonInclude(JsonInclude.Include.NON_NULL)
public class JobLogsTopic extends Topic {
  public static final String JSON_PROPERTY_PROJECT_ID = "projectId";
  public static final String JSON_PROPERTY_JOB_ID = "jobId";
  public static final String JSON_PROPERTY_FLOW_NODE_ID = "flowNodeId";
  public static final String JSON_PROPERTY_LOG_NAME = "logName";
  public static final String JSON_PROPERTY_ENCODING = "encoding";

  private static final HashSet<Charset> SUPPORTED_CHARSETS = new HashSet<>(3);

  static {
    SUPPORTED_CHARSETS.add(StandardCharsets.US_ASCII);
    SUPPORTED_CHARSETS.add(StandardCharsets.ISO_8859_1);
    SUPPORTED_CHARSETS.add(StandardCharsets.UTF_8);
  }

  private final Integer UUID;
  @EqualsAndHashCode.Include private String projectId;
  @EqualsAndHashCode.Include private String jobId;
  @EqualsAndHashCode.Include private Integer flowNodeId;
  @EqualsAndHashCode.Include private String logName;
  @EqualsAndHashCode.Include private Charset encoding;

  @JsonCreator
  public JobLogsTopic(
      @JsonProperty(value = JSON_PROPERTY_PROJECT_ID, required = true) String projectId,
      @JsonProperty(value = JSON_PROPERTY_JOB_ID, required = true) String jobId,
      @JsonProperty(value = JSON_PROPERTY_FLOW_NODE_ID, required = false) Integer flowNodeId,
      @JsonProperty(value = JSON_PROPERTY_LOG_NAME, required = false) String logName,
      @JsonProperty(value = JSON_PROPERTY_ENCODING, required = false) String encoding) {
    this.topicType = TopicType.JOBLOGS;
    this.projectId = projectId;
    this.jobId = jobId;
    this.flowNodeId = flowNodeId;
    this.logName = logName;
    try {
      this.encoding = Charset.forName(encoding);
      if (!SUPPORTED_CHARSETS.contains(this.encoding)) {
        this.encoding = null;
      }
    } catch (IllegalArgumentException e) {
      this.encoding = null;
    }
    this.UUID =
        Objects.hash(this.projectId, this.jobId, this.flowNodeId, this.logName, this.encoding);
  }

  @JsonIgnore
  @Override
  public Integer getUUID() {
    return UUID;
  }
}
