package br.pucrio.tecgraf.soma.logsmonitor.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NonNull;
import lombok.ToString;

import java.util.List;

@Getter
@EqualsAndHashCode(onlyExplicitlyIncluded = true, callSuper = true)
@ToString
@JsonPropertyOrder({
  TopicEvent.JSON_PROPERTY_TOPIC_EVENT_TYPE,
  JobLogsTopicEvent.JSON_PROPERTY_PROJECT_ID,
  JobLogsTopicEvent.JSON_PROPERTY_JOB_ID,
  JobLogsTopicEvent.JSON_PROPERTY_FLOW_NODE_ID,
  JobLogsTopicEvent.JSON_PROPERTY_LOG_NAME,
  JobLogsTopicEvent.JSON_PROPERTY_SEQNUM,
  JobLogsTopicEvent.JSON_PROPERTY_OFFSET,
  JobLogsTopicEvent.JSON_PROPERTY_LENGTH,
  JobLogsTopicEvent.JSON_PROPERTY_TOTAL_SIZE,
  JobLogsTopicEvent.JSON_PROPERTY_FILE_ENCODING,
  JobLogsTopicEvent.JSON_PROPERTY_CHUNKS
})
public class JobLogsTopicEvent extends TopicEvent {
  public static final String JSON_PROPERTY_PROJECT_ID = "projectId";
  public static final String JSON_PROPERTY_JOB_ID = "jobId";
  public static final String JSON_PROPERTY_FLOW_NODE_ID = "flowNodeId";
  public static final String JSON_PROPERTY_LOG_NAME = "logName";
  public static final String JSON_PROPERTY_SEQNUM = "seqnum";
  public static final String JSON_PROPERTY_OFFSET = "offset";
  public static final String JSON_PROPERTY_LENGTH = "length";
  public static final String JSON_PROPERTY_TOTAL_SIZE = "totalSize";
  public static final String JSON_PROPERTY_FILE_ENCODING = "fileEncoding";
  public static final String JSON_PROPERTY_CHUNKS = "chunks";

  @NonNull @EqualsAndHashCode.Include private final String projectId;
  @NonNull @EqualsAndHashCode.Include private final String jobId;
  @NonNull @EqualsAndHashCode.Include private final Integer flowNodeId;
  @NonNull @EqualsAndHashCode.Include private final String logName;
  @NonNull @EqualsAndHashCode.Include private final Long seqnum;
  @NonNull @EqualsAndHashCode.Include private final Long offset;
  @NonNull @EqualsAndHashCode.Include private final Integer length;
  @NonNull @EqualsAndHashCode.Include private final Long totalSize;
  @NonNull @EqualsAndHashCode.Include private final String fileEncoding;
  @NonNull private final List<DataChunk> chunks;

  @JsonCreator
  public JobLogsTopicEvent(
      @NonNull @JsonProperty(value = JSON_PROPERTY_PROJECT_ID, required = true) String projectId,
      @NonNull @JsonProperty(value = JSON_PROPERTY_JOB_ID, required = true) String jobId,
      @NonNull @JsonProperty(value = JSON_PROPERTY_FLOW_NODE_ID, required = true)
          Integer flowNodeId,
      @NonNull @JsonProperty(value = JSON_PROPERTY_LOG_NAME, required = true) String logName,
      @NonNull @JsonProperty(value = JSON_PROPERTY_SEQNUM, required = true) Long seqnum,
      @NonNull @JsonProperty(value = JSON_PROPERTY_OFFSET, required = true) Long offset,
      @NonNull @JsonProperty(value = JSON_PROPERTY_LENGTH, required = true) Integer length,
      @NonNull @JsonProperty(value = JSON_PROPERTY_TOTAL_SIZE, required = true) Long totalSize,
      @NonNull @JsonProperty(value = JSON_PROPERTY_FILE_ENCODING, required = true)
          String fileEncoding,
      @NonNull @JsonProperty(value = JSON_PROPERTY_CHUNKS, required = true)
          List<DataChunk> chunks) {

    super(TopicEventType.JOBLOGSEVENT);
    this.projectId = projectId;
    this.jobId = jobId;
    this.flowNodeId = flowNodeId;
    this.logName = logName;
    this.seqnum = seqnum;
    this.offset = offset;
    this.length = length;
    this.totalSize = totalSize;
    this.fileEncoding = fileEncoding;
    this.chunks = chunks;
  }
}
