package br.pucrio.tecgraf.soma.logsmonitor.model;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.EqualsAndHashCode;
import lombok.Getter;

@Getter
@EqualsAndHashCode
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.EXISTING_PROPERTY,
    property = "topicEventType",
    visible = true)
@JsonSubTypes({@JsonSubTypes.Type(value = JobLogsTopicEvent.class, name = "jobLogsEvent")})
public abstract class TopicEvent {
  public static final String JSON_PROPERTY_TOPIC_EVENT_TYPE = "topicEventType";

  protected final TopicEventType topicEventType;

  protected TopicEvent(TopicEventType topicEventType) {
    this.topicEventType = topicEventType;
  }
}
