package br.pucrio.tecgraf.soma.logsmonitor.model.error;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.EqualsAndHashCode;
import lombok.Getter;

@Getter
@EqualsAndHashCode
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.EXISTING_PROPERTY,
    property = "errorEventType",
    visible = true)
@JsonSubTypes({
  @JsonSubTypes.Type(value = InvalidMessageErrorEvent.class, name = "generalErrorEvent"),
  @JsonSubTypes.Type(
      value = ProjectPermissionErrorEvent.class,
      name = "projectPermissionErrorEvent"),
  @JsonSubTypes.Type(value = MissingFieldErrorEvent.class, name = "missingFieldErrorEvent"),
  @JsonSubTypes.Type(
      value = InvalidFieldValueErrorEvent.class,
      name = "invalidFieldValueErrorEvent"),
  @JsonSubTypes.Type(value = ResourceErrorEvent.class, name = "resourceErrorEvent"),
})
public abstract class ErrorEvent {
  public static final String JSON_PROPERTY_TOPIC_EVENT_TYPE = "errorEventType";

  @JsonIgnore protected final ErrorEventType errorEventType;

  protected ErrorEvent(ErrorEventType errorEventType) {
    this.errorEventType = errorEventType;
  }
}
