package br.pucrio.tecgraf.soma.logsmonitor.model.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ErrorType {
  INVALID_MESSAGE("invalidMessageError"),
  PROJECT_PERMISSION_ERROR("projectPermissionError"),
  MISSING_FIELD_ERROR("missingFieldError"),
  INVALID_FIELD_VALUE_ERROR("invalidFieldValueError"),
  RESOURCE_ERROR("resourceError");

  private final String value;

  ErrorType(String value) {
    this.value = value;
  }

  @JsonCreator
  public static ErrorType fromValue(String value) {
    for (ErrorType b : ErrorType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    throw new IllegalArgumentException("Unexpected value '" + value + "'");
  }

  @JsonValue
  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }
}
