package br.pucrio.tecgraf.soma.logsmonitor.model.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NonNull;
import lombok.ToString;

@Getter
@EqualsAndHashCode(onlyExplicitlyIncluded = true, callSuper = true)
@ToString
@JsonPropertyOrder({
  ErrorEvent.JSON_PROPERTY_TOPIC_EVENT_TYPE,
  MissingFieldErrorEvent.JSON_PROPERTY_FIELD_NAME
})
public class MissingFieldErrorEvent extends ErrorEvent {
  public static final String JSON_PROPERTY_FIELD_NAME = "fieldName";
  @NonNull @EqualsAndHashCode.Include private final String fieldName;

  @JsonCreator
  public MissingFieldErrorEvent(
      @NonNull @JsonProperty(value = JSON_PROPERTY_FIELD_NAME, required = true) String fieldName) {
    super(ErrorEventType.MISSING_FIELD_ERROR_EVENT);
    this.fieldName = fieldName;
  }
}
