package br.pucrio.tecgraf.soma.logsmonitor.model.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NonNull;
import lombok.ToString;

@Getter
@EqualsAndHashCode(onlyExplicitlyIncluded = true)
@ToString
@JsonPropertyOrder({
  NotificationError.JSON_PROPERTY_SUBSCRIPTION_ID,
  NotificationError.JSON_PROPERTY_MESSAGE,
  NotificationError.JSON_PROPERTY_ERROR_TYPE,
  NotificationError.JSON_PROPERTY_EVENT
})
public class NotificationError {
  public static final String JSON_PROPERTY_SUBSCRIPTION_ID = "subscriptionId";
  public static final String JSON_PROPERTY_ERROR_TYPE = "errorType";
  public static final String JSON_PROPERTY_EVENT = "errorEvent";
  public static final String JSON_PROPERTY_MESSAGE = "message";
  @NonNull @EqualsAndHashCode.Include private final String subscriptionId;
  @NonNull @EqualsAndHashCode.Include private final ErrorType errorType;
  @NonNull @EqualsAndHashCode.Include private final String message; // short description of error
  @EqualsAndHashCode.Include private final ErrorEvent errorEvent;

  @JsonCreator
  public NotificationError(
      @NonNull @JsonProperty(value = JSON_PROPERTY_SUBSCRIPTION_ID, required = true)
          String subscriptionId,
      @NonNull @JsonProperty(value = JSON_PROPERTY_ERROR_TYPE, required = true) ErrorType errorType,
      @NonNull @JsonProperty(value = JSON_PROPERTY_MESSAGE, required = true) String message,
      @JsonProperty(value = JSON_PROPERTY_EVENT, required = true) ErrorEvent errorEvent) {
    this.subscriptionId = subscriptionId;
    this.errorType = errorType;
    this.message = message;
    this.errorEvent = errorEvent;
  }
}
