package br.pucrio.tecgraf.soma.logsmonitor.model.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NonNull;
import lombok.ToString;

@Getter
@EqualsAndHashCode(onlyExplicitlyIncluded = true, callSuper = true)
@ToString
@JsonPropertyOrder({
  ErrorEvent.JSON_PROPERTY_TOPIC_EVENT_TYPE,
  ProjectPermissionErrorEvent.JSON_PROPERTY_PROJECT_ID
})
public class ProjectPermissionErrorEvent extends ErrorEvent {
  public static final String JSON_PROPERTY_PROJECT_ID = "projectId";

  @NonNull @EqualsAndHashCode.Include private final String projectId;

  @JsonCreator
  public ProjectPermissionErrorEvent(
      @NonNull @JsonProperty(value = JSON_PROPERTY_PROJECT_ID, required = true) String projectId) {
    super(ErrorEventType.PROJECT_PERMISSION_ERROR_EVENT);
    this.projectId = projectId;
  }
}
