package br.pucrio.tecgraf.soma.logsmonitor.model.error;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NonNull;
import lombok.ToString;

@Getter
@EqualsAndHashCode(onlyExplicitlyIncluded = true, callSuper = true)
@ToString
@JsonPropertyOrder({ResourceErrorEvent.JSON_PROPERTY_DETAILS})
public class ResourceErrorEvent extends ErrorEvent {
  public static final String JSON_PROPERTY_DETAILS = "details";
  @NonNull @EqualsAndHashCode.Include private final String details;

  public ResourceErrorEvent(
      @NonNull @JsonProperty(value = JSON_PROPERTY_DETAILS, required = true) String details) {
    super(ErrorEventType.RESOURCE_ERROR_EVENT);
    this.details = details;
  }
}
