package br.pucrio.tecgraf.soma.logsmonitor.model.mapper;

import br.pucrio.tecgraf.soma.job.log.monitor.event.FileChunk;
import br.pucrio.tecgraf.soma.logsmonitor.model.*;
import br.pucrio.tecgraf.soma.logsmonitor.monitor.ResourceMonitorEvent;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class JobLogsTopicEventMapper implements TopicEventMapper {
  @Override
  public TopicType getTopicType() {
    return TopicType.JOBLOGS;
  }

  @Override
  public TopicEvent map(ResourceMonitorEvent sourceEvent, Topic topic) {
    JobLogsTopic jobLogsTopic = (JobLogsTopic) topic;

    List<DataChunk> chunks = new ArrayList<>();

    FileChunk fc = (FileChunk) sourceEvent.getData();
    String data = fc.getData();
    // TODO: Não estamos quebrando o file chunk.
    chunks.add(new DataChunk(fc.getOffset(), fc.getLength(), data));

    return new JobLogsTopicEvent(
        jobLogsTopic.getProjectId(),
        jobLogsTopic.getJobId(),
        jobLogsTopic.getFlowNodeId(),
        jobLogsTopic.getLogName(),
        sourceEvent.getEndSeqnum(),
        fc.getOffset(),
        fc.getLength(),
        fc.getFileLength(),
        fc.getFileEncoding().name(),
        chunks);
  }
}
