package br.pucrio.tecgraf.soma.logsmonitor.service;

import br.pucrio.tecgraf.soma.logsmonitor.model.Topic;
import br.pucrio.tecgraf.soma.logsmonitor.model.TopicType;
import br.pucrio.tecgraf.soma.logsmonitor.monitor.ResourceMonitorEvent;
import org.springframework.web.socket.WebSocketSession;

import java.util.List;

public interface TopicService {
  TopicType getTopicType();

  boolean subscribe(Topic topic, WebSocketSession session, String subscriptionId, Long seqnum);

  boolean unsubscribe(String sessionId, Topic topic);

  List<ResourceMonitorEvent> getEvents(Topic topic, Long startSeqnum, Long endSeqnum);
}
