/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.log.monitor.impl;

import br.pucrio.tecgraf.soma.job.log.monitor.event.FileChunk;
import br.pucrio.tecgraf.soma.job.log.monitor.event.FileChunkEvent;
import br.pucrio.tecgraf.soma.job.log.monitor.model.LogFileMonitoredResource;
import br.pucrio.tecgraf.soma.job.log.reader.FileReader;
import br.pucrio.tecgraf.soma.job.log.watcher.impl.DefaultFileWatcher;
import br.pucrio.tecgraf.soma.job.log.watcher.impl.JobLogFileWatcher;
import br.pucrio.tecgraf.soma.job.log.watcher.impl.PollingFileWatcher;
import br.pucrio.tecgraf.soma.job.log.watcher.interfaces.IFileWatchEventListener;
import br.pucrio.tecgraf.soma.job.log.watcher.interfaces.IFileWatcher;
import br.pucrio.tecgraf.soma.logsmonitor.monitor.ResourceMonitor;
import br.pucrio.tecgraf.soma.logsmonitor.monitor.ResourceMonitorEvent;
import br.pucrio.tecgraf.soma.logsmonitor.monitor.ResourceMonitorListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Flow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobLogMonitor
implements ResourceMonitor {
    public static final String TIMESTAMP_PARAMETER = "timestamp";
    public static final String ENCODING_PARAMETER = "encoding";
    private final Logger LOG = LoggerFactory.getLogger(JobLogMonitor.class);
    private final Map<String, LogFileMonitoredResource> monitoredResourcesByPath;
    private final Map<String, JobLogFileWatcher> watchersByParentPath;
    private final Map<String, Set<ResourceMonitorListener<ResourceMonitorEvent>>> listenersByPath;
    private final ExecutorService threadPool;
    private final FileReader fileReader;
    private boolean enableWatcherPolling;
    private Integer watcherThreadPoolSize;
    private Integer watcherPollingIntervalMillis;
    private boolean allListenersWereRemoved = false;

    public JobLogMonitor(Integer maxLengthSize, boolean enableWatcherPolling, Integer watcherThreadPoolSize, Integer watcherPollingIntervalMillis, Charset defaultCharset, boolean enableCharsetDetection) {
        this(Executors.newCachedThreadPool(), new FileReader(maxLengthSize, defaultCharset, enableCharsetDetection), enableWatcherPolling, watcherThreadPoolSize, watcherPollingIntervalMillis, new ConcurrentHashMap(), new ConcurrentHashMap(), new ConcurrentHashMap());
    }

    public JobLogMonitor(ExecutorService pool, FileReader fileReader, boolean enableWatcherPolling, Integer watcherThreadPoolSize, Integer watcherPollingIntervalMillis, Map<String, LogFileMonitoredResource> monitoredResourcesByPath, Map<String, JobLogFileWatcher> watchersByParentPath, Map<String, Set<ResourceMonitorListener<ResourceMonitorEvent>>> listenersByPath) {
        this.monitoredResourcesByPath = monitoredResourcesByPath;
        this.watchersByParentPath = watchersByParentPath;
        this.listenersByPath = listenersByPath;
        this.fileReader = fileReader;
        this.threadPool = pool;
        this.enableWatcherPolling = enableWatcherPolling;
        this.watcherThreadPoolSize = watcherThreadPoolSize;
        this.watcherPollingIntervalMillis = watcherPollingIntervalMillis;
    }

    public synchronized void addListener(String filePath, ResourceMonitorListener<ResourceMonitorEvent> listener, Map<String, Object> args) {
        this.LOG.info("Starting monitor with: [filepath={}, timestamp={}, encoding={}]", new Object[]{filePath, this.getTimestampFromArgs(args), this.getEncodingFromArgs(args)});
        this.createMonitoredResource(filePath, listener, this.getTimestampFromArgs(args), this.getEncodingFromArgs(args));
        try {
            this.createFileWatcher(filePath);
        }
        catch (FileNotFoundException e) {
            this.LOG.error("File {} not found", (Object)filePath);
            listener.onError((Throwable)e);
        }
        catch (IOException e) {
            this.LOG.error("Cannot create watch service!");
            listener.onError((Throwable)e);
        }
        listener.onSubscribe(this.createSubscription(filePath, listener));
    }

    private Flow.Subscription createSubscription(String filePath, ResourceMonitorListener<ResourceMonitorEvent> listener) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public synchronized void removeListener(String filePath, ResourceMonitorListener<ResourceMonitorEvent> listener) {
        this.LOG.info("Stopping monitor for ID [{}]", (Object)filePath);
        this.allListenersWereRemoved = false;
        ((Set)this.listenersByPath.get(filePath)).remove(listener);
        if (((Set)this.listenersByPath.get(filePath)).isEmpty()) {
            this.listenersByPath.remove(filePath);
            this.monitoredResourcesByPath.remove(filePath);
            String parentPath = this.getParentDirFromPath(filePath);
            JobLogFileWatcher watcher = (JobLogFileWatcher)this.watchersByParentPath.get(parentPath);
            if (watcher != null) {
                watcher.removeMonitoredFilePath(filePath);
                if (watcher.isMonitoredFilePathsEmpty()) {
                    try {
                        this.LOG.debug("Closing watcher for events...");
                        watcher.close();
                    }
                    catch (IOException e) {
                        this.LOG.error("Cannot close the watcher for directory: {}", (Object)parentPath, (Object)e);
                        e.printStackTrace();
                    }
                    this.LOG.debug("WATCHER: removing watcher from MAP");
                    this.watchersByParentPath.remove(parentPath);
                }
            } else {
                this.LOG.debug("Ignoring non existent watcher removal for file path {}!", (Object)filePath);
            }
            this.allListenersWereRemoved = true;
        }
    }

    public List<ResourceMonitorEvent> getEvents(String filePath, Long startSeqnum, Long endSeqnum) {
        LogFileMonitoredResource resource = (LogFileMonitoredResource)this.monitoredResourcesByPath.get(filePath);
        LinkedList<ResourceMonitorEvent> events = new LinkedList<ResourceMonitorEvent>();
        if (startSeqnum != null && endSeqnum != null) {
            FileChunk chunk;
            Long currSeqnum = startSeqnum;
            while (currSeqnum < endSeqnum && (chunk = this.readFile(filePath, currSeqnum, Integer.valueOf((int)(endSeqnum - currSeqnum)), resource.getEncoding())) != null) {
                FileChunkEvent event = new FileChunkEvent(chunk);
                currSeqnum = event.getEndSeqnum();
                events.add((ResourceMonitorEvent)event);
            }
        }
        return events;
    }

    public void finishMonitoring() {
        this.LOG.info("Shutting down executor threads...");
        this.threadPool.shutdown();
    }

    public boolean isAllListenersWereRemoved() {
        return this.allListenersWereRemoved;
    }

    private synchronized void createFileWatcher(String filePath) throws IOException {
        String parentPath = this.getParentDirFromPath(filePath);
        File file = Paths.get(filePath, new String[0]).toFile();
        this.LOG.debug("File Name and Parent Dir Name: {} : {} ({})", new Object[]{new File(filePath).getName(), new File(parentPath).getName(), filePath});
        if (!file.exists() || !file.isFile()) {
            this.LOG.debug("File {} not found", (Object)filePath);
            throw new FileNotFoundException("File not found");
        }
        if (!file.canRead()) {
            this.LOG.debug("File {} is not readable", (Object)filePath);
            throw new FileNotFoundException("File is not readable");
        }
        if (!this.watchersByParentPath.containsKey(parentPath)) {
            JobLogFileWatcher jobLogFileWatcher = this.createJobLogFileWatcher();
            jobLogFileWatcher.addMonitoredFilePath(filePath);
            this.watchersByParentPath.put(parentPath, jobLogFileWatcher);
            this.threadPool.execute(() -> {
                this.LOG.debug("Thread is executing for filePath: [{}]", (Object)filePath);
                try {
                    this.LOG.debug("Adding FileWatchEventListener...");
                    jobLogFileWatcher.addFileWatchEventListener(this.createFileWatchEventListener());
                    this.LOG.debug("Registering WatchService...");
                    jobLogFileWatcher.register();
                    this.LOG.debug("Start watch service to take for events...");
                    jobLogFileWatcher.startWatch();
                }
                catch (InterruptedException ie) {
                    this.LOG.error("Watcher was interrupted:", (Throwable)ie);
                    this.notifyErrorsToListeners(filePath, (Throwable)ie);
                }
                catch (IOException ioe) {
                    this.LOG.error("Watch was not registered", (Throwable)ioe);
                    this.notifyErrorsToListeners(filePath, (Throwable)ioe);
                }
                this.LOG.debug("Thread is stopping for path: [{}]", (Object)filePath);
            });
        } else {
            this.LOG.debug("Add file Path to watcher: {}", (Object)filePath);
            JobLogFileWatcher jobLogFileWatcher = (JobLogFileWatcher)this.watchersByParentPath.get(parentPath);
            jobLogFileWatcher.addMonitoredFilePath(filePath);
        }
    }

    protected JobLogFileWatcher createJobLogFileWatcher() throws IOException {
        PollingFileWatcher fileWatcher;
        if (this.enableWatcherPolling) {
            fileWatcher = new PollingFileWatcher(this.watcherPollingIntervalMillis);
            this.LOG.debug("Creating PollingFileWatcher...");
        } else {
            fileWatcher = new DefaultFileWatcher(this.watcherThreadPoolSize);
            this.LOG.debug("Creating DefaultFileWatcher...");
        }
        return new JobLogFileWatcher((IFileWatcher)fileWatcher);
    }

    private IFileWatchEventListener createFileWatchEventListener() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private void createMonitoredResource(String filePath, ResourceMonitorListener<ResourceMonitorEvent> listener, Long timestamp, Charset encoding) {
        if (!this.monitoredResourcesByPath.containsKey(filePath)) {
            this.monitoredResourcesByPath.put(filePath, new LogFileMonitoredResource(filePath, timestamp, encoding));
        }
        if (!this.listenersByPath.containsKey(filePath)) {
            this.listenersByPath.put(filePath, new HashSet());
        }
        if (!((Set)this.listenersByPath.get(filePath)).add(listener)) {
            this.LOG.debug("Listener for path {} already registered!", (Object)filePath);
        }
    }

    private void notifyErrorsToListeners(String filePath, Throwable throwable) {
        Set listeners = (Set)this.listenersByPath.get(filePath);
        if (listeners != null && !listeners.isEmpty()) {
            listeners.forEach(l -> l.onError(throwable));
        }
    }

    private FileChunk readFile(String filePath, Long timestamp, Integer length, Charset forcedCharset) {
        try {
            FileChunk chunk = this.fileReader.readFile(filePath, timestamp, length, forcedCharset);
            if (chunk == null || chunk.getData().length() == 0) {
                return null;
            }
            this.LOG.debug("FileChunk [file: {}, fileLength:{}, offset:{}, data length: {}] ", new Object[]{chunk.getPath().toFile().getName(), chunk.getFileLength(), chunk.getOffset(), chunk.getLength()});
            return chunk;
        }
        catch (IOException e) {
            this.LOG.error("Cannot read file chunk from file [{}, {}, {}, {}]", new Object[]{filePath, timestamp, this.fileReader.getMaxLengthSize(), e.getMessage()});
            this.notifyErrorsToListeners(filePath, (Throwable)e);
            return null;
        }
    }

    private Long getTimestampFromArgs(Map<String, Object> params) {
        return (Long)params.get(TIMESTAMP_PARAMETER);
    }

    private Charset getEncodingFromArgs(Map<String, Object> params) {
        return (Charset)params.get(ENCODING_PARAMETER);
    }

    private String getParentDirFromPath(String fileAbsPath) {
        return Paths.get(fileAbsPath, new String[0]).getParent().toString();
    }
}

