/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.logsmonitor;

import java.util.Arrays;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.stereotype.Component;

@Component
public class PropertyLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyLogger.class);

    @EventListener
    public void handleContextRefresh(ContextRefreshedEvent event) {
        Environment env = event.getApplicationContext().getEnvironment();
        LOGGER.info("====== Job Logs Monitor Properties ======");
        LOGGER.info("Active profiles: {}", (Object)Arrays.toString(env.getActiveProfiles()));
        MutablePropertySources sources = ((AbstractEnvironment)env).getPropertySources();
        StreamSupport.stream(sources.spliterator(), false).filter(propSource -> propSource instanceof EnumerablePropertySource).map(propSource -> ((EnumerablePropertySource)propSource).getPropertyNames()).flatMap(Arrays::stream).filter(propName -> propName.startsWith("job.logs.monitor")).distinct().forEach(prop -> LOGGER.info("{}: {}", prop, (Object)env.getProperty(prop)));
        LOGGER.info("===========================================");
    }
}

