/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.logsmonitor.model;

import br.pucrio.tecgraf.soma.logsmonitor.model.Topic;
import br.pucrio.tecgraf.soma.logsmonitor.model.TopicType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class JobLogsTopic
extends Topic {
    public static final String JSON_PROPERTY_PROJECT_ID = "projectId";
    public static final String JSON_PROPERTY_JOB_ID = "jobId";
    public static final String JSON_PROPERTY_FLOW_NODE_ID = "flowNodeId";
    public static final String JSON_PROPERTY_LOG_NAME = "logName";
    public static final String JSON_PROPERTY_ENCODING = "encoding";
    private static final HashSet<Charset> SUPPORTED_CHARSETS = new HashSet(3);
    private final Integer UUID;
    private String projectId;
    private String jobId;
    private Integer flowNodeId;
    private String logName;
    private Charset encoding;

    @JsonCreator
    public JobLogsTopic(@JsonProperty(value="projectId", required=true) String projectId, @JsonProperty(value="jobId", required=true) String jobId, @JsonProperty(value="flowNodeId", required=false) Integer flowNodeId, @JsonProperty(value="logName", required=false) String logName, @JsonProperty(value="encoding", required=false) String encoding) {
        this.topicType = TopicType.JOBLOGS;
        this.projectId = projectId;
        this.jobId = jobId;
        this.flowNodeId = flowNodeId;
        this.logName = logName;
        try {
            this.encoding = Charset.forName(encoding);
            if (!SUPPORTED_CHARSETS.contains(this.encoding)) {
                this.encoding = null;
            }
        }
        catch (IllegalArgumentException e) {
            this.encoding = null;
        }
        this.UUID = Objects.hash(this.projectId, this.jobId, this.flowNodeId, this.logName, this.encoding);
    }

    @JsonIgnore
    public Integer getUUID() {
        return this.UUID;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public Integer getFlowNodeId() {
        return this.flowNodeId;
    }

    public String getLogName() {
        return this.logName;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public void setFlowNodeId(Integer flowNodeId) {
        this.flowNodeId = flowNodeId;
    }

    public void setLogName(String logName) {
        this.logName = logName;
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobLogsTopic)) {
            return false;
        }
        JobLogsTopic other = (JobLogsTopic)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$flowNodeId = this.getFlowNodeId();
        Integer other$flowNodeId = other.getFlowNodeId();
        if (this$flowNodeId == null ? other$flowNodeId != null : !((Object)this$flowNodeId).equals(other$flowNodeId)) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
            return false;
        }
        String this$jobId = this.getJobId();
        String other$jobId = other.getJobId();
        if (this$jobId == null ? other$jobId != null : !this$jobId.equals(other$jobId)) {
            return false;
        }
        String this$logName = this.getLogName();
        String other$logName = other.getLogName();
        if (this$logName == null ? other$logName != null : !this$logName.equals(other$logName)) {
            return false;
        }
        Charset this$encoding = this.getEncoding();
        Charset other$encoding = other.getEncoding();
        return !(this$encoding == null ? other$encoding != null : !((Object)this$encoding).equals(other$encoding));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JobLogsTopic;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $flowNodeId = this.getFlowNodeId();
        result = result * 59 + ($flowNodeId == null ? 43 : ((Object)$flowNodeId).hashCode());
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        String $jobId = this.getJobId();
        result = result * 59 + ($jobId == null ? 43 : $jobId.hashCode());
        String $logName = this.getLogName();
        result = result * 59 + ($logName == null ? 43 : $logName.hashCode());
        Charset $encoding = this.getEncoding();
        result = result * 59 + ($encoding == null ? 43 : ((Object)$encoding).hashCode());
        return result;
    }

    public String toString() {
        return "JobLogsTopic(UUID=" + this.getUUID() + ", projectId=" + this.getProjectId() + ", jobId=" + this.getJobId() + ", flowNodeId=" + this.getFlowNodeId() + ", logName=" + this.getLogName() + ", encoding=" + this.getEncoding() + ")";
    }

    static {
        SUPPORTED_CHARSETS.add(StandardCharsets.US_ASCII);
        SUPPORTED_CHARSETS.add(StandardCharsets.ISO_8859_1);
        SUPPORTED_CHARSETS.add(StandardCharsets.UTF_8);
    }
}

