/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.logsmonitor.model.mapper;

import br.pucrio.tecgraf.soma.logsmonitor.model.TopicType;
import br.pucrio.tecgraf.soma.logsmonitor.model.mapper.TopicEventMapper;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TopicEventMapperFactory {
    private final Map<TopicType, TopicEventMapper> eventMapperByTopic;

    @Autowired
    public TopicEventMapperFactory(List<TopicEventMapper> topicEventMappers) {
        this.eventMapperByTopic = topicEventMappers.stream().collect(Collectors.toMap(TopicEventMapper::getTopicType, Function.identity()));
    }

    public TopicEventMapper getEventMapperByTopicType(TopicType type) {
        return (TopicEventMapper)this.eventMapperByTopic.get(type);
    }
}

