/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.logsmonitor.model.validator;

import br.pucrio.tecgraf.soma.logsmonitor.model.JobLogsTopic;
import java.util.Base64;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

@Component
@Primary
public class JobLogsTopicValidator
implements Validator {
    public boolean supports(Class<?> aClass) {
        return JobLogsTopic.class.isAssignableFrom(aClass);
    }

    public void validate(Object o, Errors errors) {
        JobLogsTopic jlt = (JobLogsTopic)o;
        this.validateAttrs("projectId", jlt.getProjectId(), errors, jlt);
        this.validateAttrs("jobId", jlt.getJobId(), errors, jlt);
        this.validateFlowNodeId(jlt.getFlowNodeId(), errors);
        this.validateIfEmpty("logName", jlt.getLogName(), errors);
    }

    private void validateAttrs(String attrName, String attrValue, Errors errors, JobLogsTopic jlt) {
        this.validateIfEmpty(attrName, attrValue, errors);
        this.validateNotBase64Encoded(attrName, attrValue, errors, jlt);
    }

    private void validateIfEmpty(String fieldName, String fieldValue, Errors errors) {
        if (fieldValue != null) {
            Object[] args = new Object[]{fieldName};
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)fieldName, (String)"invalid.empty.value", (Object[])args, (String)"Attribute %s cannot be empty or have white spaces.");
        }
    }

    private void validateNotBase64Encoded(String fieldName, String fieldValue, Errors errors, JobLogsTopic jlt) {
        Object[] args = new Object[]{fieldName};
        try {
            Base64.getDecoder().decode(fieldValue);
        }
        catch (IllegalArgumentException e) {
            errors.rejectValue(fieldName, "not.encoded.value", args, "Attribute %s must be encoded in base64.");
        }
    }

    private void validateFlowNodeId(Integer flowNodeId, Errors errors) {
        if (flowNodeId != null && flowNodeId < 0) {
            Object[] args = new Object[]{"flowNodeId"};
            errors.rejectValue("flowNodeId", "invalid.negative.value", args, "Invalid value for attribute %s. Value must be >= 0");
        }
    }
}

