/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.logsmonitor.model.validator;

import br.pucrio.tecgraf.soma.logsmonitor.model.Command;
import br.pucrio.tecgraf.soma.logsmonitor.model.JobLogsTopic;
import br.pucrio.tecgraf.soma.logsmonitor.model.Message;
import br.pucrio.tecgraf.soma.logsmonitor.model.Topic;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

@Component
public class MessageValidator
implements Validator {
    private final Validator topicValidator;

    public MessageValidator(Validator topicValidator) {
        if (topicValidator == null) {
            throw new IllegalArgumentException("The supplied [Validator] is required and must not be null.");
        }
        if (!topicValidator.supports(JobLogsTopic.class)) {
            throw new IllegalArgumentException("The supplied [Validator] must support the validation of [JobLogsTopic] instances.");
        }
        this.topicValidator = topicValidator;
    }

    public boolean supports(Class<?> aClass) {
        return Message.class.isAssignableFrom(aClass);
    }

    public void validate(Object o, Errors errors) {
        Message msg = (Message)o;
        this.validateSubscriptionId(msg.getSubscriptionId(), errors);
        this.validateSeqNum(msg.getCommand(), msg.getSeqnum(), errors);
        this.validateTopic(msg.getTopic(), errors);
    }

    private void validateSubscriptionId(String subsId, Errors errors) {
        Object[] args = new Object[]{"subscriptionId"};
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"subscriptionId", (String)"invalid.empty.value", (Object[])args, (String)"Attribute %s cannot be empty or have white spaces.");
    }

    private void validateTopic(Topic topic, Errors errors) {
        try {
            errors.pushNestedPath("topic");
            ValidationUtils.invokeValidator((Validator)this.topicValidator, (Object)topic, (Errors)errors);
        }
        finally {
            errors.popNestedPath();
        }
    }

    private void validateSeqNum(Command command, Long seqNum, Errors errors) {
        if (Command.SUBSCRIBE.equals((Object)command)) {
            if (seqNum == null) {
                Object[] args = new Object[]{"seqnum"};
                errors.rejectValue("seqnum", "missing.value", args, "Missing attribute value for %s.");
            } else if (seqNum < 0L) {
                Object[] args = new Object[]{"seqnum"};
                errors.rejectValue("seqnum", "invalid.negative.value", args, "Invalid value for attribute %s. Value must be >= 0");
            }
        }
    }
}

