/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.logsmonitor.service;

import br.pucrio.tecgraf.soma.logsmonitor.model.TopicType;
import br.pucrio.tecgraf.soma.logsmonitor.service.TopicService;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TopicServiceFactory {
    private final Map<TopicType, TopicService> servicesByTopic;

    @Autowired
    public TopicServiceFactory(List<TopicService> topicServices) {
        this.servicesByTopic = topicServices.stream().collect(Collectors.toMap(TopicService::getTopicType, Function.identity()));
    }

    public TopicService getServiceByTopicType(TopicType type) {
        return (TopicService)this.servicesByTopic.get(type);
    }
}

