/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.logservice.contoller;

import br.pucrio.tecgraf.soma.logservice.api.JobsApi;
import br.pucrio.tecgraf.soma.logservice.api.model.DataChunk;
import br.pucrio.tecgraf.soma.logservice.api.model.JobLogPagination;
import br.pucrio.tecgraf.soma.logservice.api.model.JobLogResponse;
import br.pucrio.tecgraf.soma.logservice.service.FileChunk;
import br.pucrio.tecgraf.soma.logservice.service.FileDataRead;
import br.pucrio.tecgraf.soma.logservice.service.JobLogService;
import br.pucrio.tecgraf.soma.logservice.utils.FileUtils;
import br.pucrio.tecgraf.soma.logservice.utils.ResponseBuilder;
import io.quarkus.runtime.configuration.CharsetConverter;
import io.smallrye.config.WithConverter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

public class JobLogController
implements JobsApi {
    private static final Logger LOG = Logger.getLogger(JobLogController.class);
    private static final String DEFAULT_LOG_NAME = "out.log";
    private static final String DEFAULT_LOG_NAME_FLOW;
    private static final HashSet<Charset> SUPPORTED_CHARSETS;
    @ConfigProperty(name="application.charset.default")
    public @WithConverter(value=CharsetConverter.class) Charset DEFAULT_CHARSET;
    @ConfigProperty(name="application.length.default")
    Integer DEFAULT_LENGTH;
    @ConfigProperty(name="application.length.max")
    Integer DEFAULT_MAX_LENGTH;
    @Inject
    JobLogService service;

    private static String getComposedLogName(String logName, Integer flowNodeId) {
        String regexStr = "(.+)\\.(.+)$";
        String replacementStr = "$1" + flowNodeId + ".$2";
        return logName.replaceAll(regexStr, replacementStr);
    }

    @Override
    public Response jobsJobIdFlowNodeIdLogsGet(String jobIdBase64, Integer flowNodeId, @NotNull String projectIdBase64, String logNameBase64, String encoding, Long offset, Integer length, Integer chunkLength) {
        String fileToRead;
        String projectId;
        String jobId;
        Charset forcedCharset;
        LOG.infof("Request to get file chunk received with parameters [jobId=%s, flowNodeId=%s, projectId=%s, logName=%s, encoding=%s, offset=%s, length=%s, chunkLength=%s]", new Object[]{jobIdBase64, flowNodeId, projectIdBase64, logNameBase64, encoding, offset, length, chunkLength});
        LOG.debugf("Configuration Property values [default_length=%s, default_max_length=%s]", (Object)this.DEFAULT_LENGTH, (Object)this.DEFAULT_MAX_LENGTH);
        try {
            forcedCharset = Charset.forName(encoding);
            if (!SUPPORTED_CHARSETS.contains(forcedCharset)) {
                forcedCharset = null;
                LOG.infof("The requested charset [%s] is unsupported. Using the default charset [%s].", (Object)encoding, (Object)this.DEFAULT_CHARSET);
            }
        }
        catch (Exception e) {
            forcedCharset = null;
            LOG.infof("The requested charset [%s] is invalid. Using the default charset [%s].", (Object)encoding, (Object)this.DEFAULT_CHARSET);
        }
        try {
            jobId = new String(Base64.getUrlDecoder().decode(jobIdBase64));
        }
        catch (IllegalArgumentException e) {
            return ResponseBuilder.buildBadRequestResponse(5);
        }
        String jobIdFixed = FileUtils.fixDirectoryName(jobId);
        try {
            projectId = new String(Base64.getDecoder().decode(projectIdBase64));
        }
        catch (IllegalArgumentException e) {
            return ResponseBuilder.buildBadRequestResponse(4);
        }
        try {
            fileToRead = this.getFileToRead(jobIdFixed, flowNodeId, projectId, logNameBase64);
        }
        catch (FileNotFoundException e) {
            LOG.errorf(e.getMessage(), (Object)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (IllegalArgumentException e) {
            return ResponseBuilder.buildBadRequestResponse(3);
        }
        length = this.adjustLength(length);
        chunkLength = chunkLength == null ? length : Math.min(chunkLength, length);
        JobLogResponse resp = new JobLogResponse();
        JobLogPagination pagination = new JobLogPagination();
        ArrayList<DataChunk> chunks = new ArrayList<DataChunk>();
        resp.pagination(pagination);
        resp.chunks(chunks);
        try {
            FileDataRead fileDataRead = this.service.readFile(fileToRead, jobIdFixed, projectId, forcedCharset, offset, length, chunkLength);
            resp.fileEncoding(fileDataRead.getFileEncoding());
            resp.seqnum(fileDataRead.getFileLength());
            pagination.totalSize(fileDataRead.getFileLength());
            pagination.offset(fileDataRead.getChunks().get(0).getOffset());
            int totalLength = 0;
            for (FileChunk fileChunk : fileDataRead.getChunks()) {
                totalLength += fileChunk.getLength().intValue();
                chunks.add(new DataChunk().data(fileChunk.getData()).offset(fileChunk.getOffset()).length(fileChunk.getLength()));
            }
            pagination.length(totalLength);
        }
        catch (IOException e) {
            LOG.errorf((Throwable)e, "Error while reading file %s", (Object)fileToRead);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.ok().entity((Object)resp).build();
    }

    @Override
    public Response jobsJobIdFlowNodeIdLogsDownloadGet(String jobIdBase64, Integer flowNodeId, String projectIdBase64, String token, String logNameBase64) {
        String fileName;
        String fileToRead;
        String projectId;
        String jobId;
        LOG.infof("Request to download file received with parameters [jobId=%s, flowNodeId=%s, projectId=%s, logName=%s]", new Object[]{jobIdBase64, flowNodeId, projectIdBase64, logNameBase64});
        try {
            jobId = new String(Base64.getUrlDecoder().decode(jobIdBase64));
        }
        catch (IllegalArgumentException e) {
            return ResponseBuilder.buildBadRequestResponse(5);
        }
        String jobIdFixed = FileUtils.fixDirectoryName(jobId);
        try {
            projectId = new String(Base64.getDecoder().decode(projectIdBase64));
        }
        catch (IllegalArgumentException e) {
            return ResponseBuilder.buildBadRequestResponse(4);
        }
        try {
            fileToRead = this.getFileToRead(jobIdFixed, flowNodeId, projectId, logNameBase64);
            fileName = this.service.getFileName(fileToRead, jobIdFixed, projectId);
        }
        catch (FileNotFoundException e) {
            LOG.errorf(e.getMessage(), (Object)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (IllegalArgumentException e) {
            return ResponseBuilder.buildBadRequestResponse(3);
        }
        try {
            InputStream fileInputStream = this.service.getFileAsStream(fileToRead, jobIdFixed, projectId);
            StreamingOutput responseOutputStream = resourceOutputStream -> {
                byte[] buffer = new byte[1024];
                try {
                    int length;
                    while ((length = fileInputStream.read(buffer)) > 0) {
                        resourceOutputStream.write(buffer, 0, length);
                    }
                }
                catch (IOException e) {
                    LOG.errorf("Erro while download log file %s", (Object)fileToRead);
                }
                finally {
                    resourceOutputStream.flush();
                    fileInputStream.close();
                }
            };
            return Response.ok((Object)responseOutputStream).type(MediaType.APPLICATION_OCTET_STREAM_TYPE).header("Content-Disposition", (Object)String.format("attachment; filename=%s", fileName)).header("Content-Length", (Object)this.service.getFileLength(fileToRead, jobIdFixed, projectId)).header("Cache-Control", (Object)"private").build();
        }
        catch (FileNotFoundException e) {
            LOG.errorf("Log file not found %s", (Object)fileToRead);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getFileToRead(String jobId, Integer flowNodeId, String projectId, String logNameBase64) throws FileNotFoundException, IllegalArgumentException {
        String fileToRead;
        if (StringUtils.isEmpty((CharSequence)logNameBase64)) {
            if (flowNodeId == 0) {
                if (this.service.fileExistsAndIsReadable(DEFAULT_LOG_NAME, jobId, projectId)) {
                    return DEFAULT_LOG_NAME;
                }
                if (!this.service.fileExistsAndIsReadable(DEFAULT_LOG_NAME_FLOW, jobId, projectId)) throw new FileNotFoundException("Log file out.log nor out0.log not found");
                return DEFAULT_LOG_NAME_FLOW;
            }
            fileToRead = JobLogController.getComposedLogName(DEFAULT_LOG_NAME, flowNodeId);
            if (this.service.fileExistsAndIsReadable(fileToRead, jobId, projectId)) return fileToRead;
            throw new FileNotFoundException(String.format("Log file not found %s", fileToRead));
        }
        fileToRead = new String(Base64.getUrlDecoder().decode(logNameBase64));
        if (this.service.fileExistsAndIsReadable(fileToRead, jobId, projectId)) return fileToRead;
        throw new FileNotFoundException(String.format("Log file not found %s", fileToRead));
    }

    private Integer adjustLength(Integer length) {
        if (length == null) {
            return this.DEFAULT_LENGTH;
        }
        if (length > this.DEFAULT_MAX_LENGTH) {
            return this.DEFAULT_MAX_LENGTH;
        }
        return length;
    }

    static {
        SUPPORTED_CHARSETS = new HashSet(3);
        DEFAULT_LOG_NAME_FLOW = JobLogController.getComposedLogName(DEFAULT_LOG_NAME, 0);
        SUPPORTED_CHARSETS.add(StandardCharsets.ISO_8859_1);
        SUPPORTED_CHARSETS.add(StandardCharsets.US_ASCII);
        SUPPORTED_CHARSETS.add(StandardCharsets.UTF_8);
    }
}

