/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.logback.classic;

import de.huxhorn.lilith.data.logging.Message;
import de.huxhorn.lilith.data.logging.MessageFormatter;
import de.huxhorn.lilith.logback.classic.NDCAdapter;
import java.util.ArrayList;
import java.util.List;

public class SimpleNDCAdapter
implements NDCAdapter {
    private CloningNdcStackThreadLocal ndcStackThreadLocal = new CloningNdcStackThreadLocal();

    public void push(String message) {
        this.getNdcStack().push(message);
    }

    public void push(String messagePattern, Object[] arguments) {
        this.getNdcStack().push(messagePattern, arguments);
    }

    public void pop() {
        this.getNdcStack().pop();
    }

    public int getDepth() {
        return this.getNdcStack().getDepth();
    }

    public void setMaximumDepth(int maximumDepth) {
        this.getNdcStack().setMaximumDepth(maximumDepth);
    }

    public boolean isEmpty() {
        return this.getNdcStack().isEmpty();
    }

    public void clear() {
        this.getNdcStack().clear();
    }

    public Message[] getContextStack() {
        return this.getNdcStack().getContextStack();
    }

    private NdcStack getNdcStack() {
        NdcStack result = (NdcStack)this.ndcStackThreadLocal.get();
        if (result == null) {
            result = new NdcStack();
            this.ndcStackThreadLocal.set(result);
        }
        return result;
    }

    private static class NdcStack
    implements Cloneable {
        private List<Message> stackList = new ArrayList<Message>();

        private NdcStack() {
        }

        public int getDepth() {
            return this.stackList.size();
        }

        public void setMaximumDepth(int maximumDepth) {
            int overflow = this.stackList.size() - maximumDepth;
            for (int i = 0; i < overflow; ++i) {
                this.pop();
            }
        }

        public void push(String message) {
            this.stackList.add(new Message(message));
        }

        public void push(String messagePattern, Object[] arguments) {
            if (arguments == null || arguments.length == 0) {
                this.push(messagePattern);
                return;
            }
            MessageFormatter.ArgumentResult argumentResults = MessageFormatter.evaluateArguments((String)messagePattern, (Object[])arguments);
            if (argumentResults == null) {
                this.stackList.add(new Message(messagePattern, null));
            } else {
                this.stackList.add(new Message(messagePattern, argumentResults.getArguments()));
            }
        }

        public void pop() {
            int size = this.stackList.size();
            if (size > 0) {
                this.stackList.remove(size - 1);
            }
        }

        public boolean isEmpty() {
            return this.stackList.isEmpty();
        }

        public void clear() {
            this.stackList.clear();
        }

        public Message[] getContextStack() {
            if (this.stackList.isEmpty()) {
                return NDCAdapter.NO_MESSAGES;
            }
            Message[] result = new Message[this.stackList.size()];
            try {
                for (int i = 0; i < this.stackList.size(); ++i) {
                    result[i] = this.stackList.get(i).clone();
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return result;
        }

        public NdcStack clone() throws CloneNotSupportedException {
            NdcStack result = (NdcStack)super.clone();
            ArrayList<Message> clonedStackList = new ArrayList<Message>(this.stackList.size());
            for (Message current : this.stackList) {
                clonedStackList.add(current.clone());
            }
            result.stackList = clonedStackList;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CloningNdcStackThreadLocal
    extends InheritableThreadLocal<NdcStack> {
        private CloningNdcStackThreadLocal() {
        }

        @Override
        protected NdcStack childValue(NdcStack parentValue) {
            NdcStack result = null;
            if (parentValue != null) {
                try {
                    result = parentValue.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
            }
            return result;
        }
    }
}

