/*
 * Decompiled with CFR 0.152.
 */
package de.juplo.plugins.hibernate;

import com.pyx4j.log4j.MavenLogAppender;
import de.juplo.plugins.hibernate.ModificationTracker;
import de.juplo.plugins.hibernate.MutableClassLoader;
import de.juplo.plugins.hibernate.SimpleConnectionProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.cfgxml.internal.ConfigLoader;
import org.hibernate.boot.cfgxml.spi.LoadedConfig;
import org.hibernate.boot.cfgxml.spi.MappingReference;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.internal.util.config.ConfigurationException;
import org.hibernate.jpa.boot.internal.ParsedPersistenceXmlDescriptor;
import org.hibernate.jpa.boot.internal.PersistenceXmlParser;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.schema.TargetType;
import org.hibernate.tool.schema.internal.ExceptionHandlerCollectingImpl;
import org.hibernate.tool.schema.internal.exec.ScriptTargetOutputToFile;
import org.hibernate.tool.schema.spi.ExceptionHandler;
import org.hibernate.tool.schema.spi.ExecutionOptions;
import org.hibernate.tool.schema.spi.SchemaManagementToolCoordinator;
import org.hibernate.tool.schema.spi.ScriptTargetOutput;
import org.hibernate.tool.schema.spi.TargetDescriptor;
import org.scannotation.AnnotationDB;

public abstract class AbstractSchemaMojo
extends AbstractMojo {
    public static final String EXECUTE = "hibernate.schema.execute";
    public static final String OUTPUTDIRECTORY = "project.build.outputDirectory";
    public static final String SCAN_CLASSES = "hibernate.schema.scan.classes";
    public static final String SCAN_DEPENDENCIES = "hibernate.schema.scan.dependencies";
    public static final String SCAN_TESTCLASSES = "hibernate.schema.scan.test_classes";
    public static final String TEST_OUTPUTDIRECTORY = "project.build.testOutputDirectory";
    public static final String SKIPPED = "hibernate.schema.skipped";
    public static final String SCRIPT = "hibernate.schema.script";
    private static final Pattern SPLIT = Pattern.compile("[^,\\s]+");
    private final Set<String> packages = new HashSet<String>();
    private MavenProject project;
    private String buildDirectory;
    private Boolean execute;
    private boolean skip;
    private boolean force;
    private String dialect;
    private String delimiter;
    private Boolean show;
    private Boolean format;
    private Boolean createNamespaces;
    private String implicitNamingStrategy;
    private String physicalNamingStrategy;
    private Boolean scanClasses;
    private String outputDirectory;
    private String scanDependencies;
    private Boolean scanTestClasses;
    private String testOutputDirectory;
    private String driver;
    private String url;
    private String username;
    private String password;
    private String hibernateProperties;
    private String hibernateConfig;
    private String persistenceUnit;
    private String mappings;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(String filename) throws MojoFailureException, MojoExecutionException {
        ModificationTracker tracker;
        if (this.skip) {
            this.getLog().info((CharSequence)"Execution of hibernate-maven-plugin was skipped!");
            this.project.getProperties().setProperty(SKIPPED, "true");
            return;
        }
        try {
            tracker = new ModificationTracker(this.buildDirectory, filename, this.getLog());
        }
        catch (NoSuchAlgorithmException e) {
            throw new MojoFailureException("Digest-Algorithm MD5 is missing!", (Throwable)e);
        }
        SimpleConnectionProvider connectionProvider = new SimpleConnectionProvider(this.getLog());
        try {
            Set<String> classes;
            Object urls;
            ParsedPersistenceXmlDescriptor unit;
            MavenLogAppender.startPluginLog((AbstractMojo)this);
            tracker.load();
            MutableClassLoader classLoader = this.createClassLoader();
            BootstrapServiceRegistry bootstrapServiceRegitry = new BootstrapServiceRegistryBuilder().applyClassLoader((ClassLoader)classLoader).build();
            ClassLoaderService classLoaderService = (ClassLoaderService)bootstrapServiceRegitry.getService(ClassLoaderService.class);
            Properties properties = new Properties();
            ConfigLoader configLoader = new ConfigLoader(bootstrapServiceRegitry);
            properties.putAll((Map<?, ?>)this.loadProperties(configLoader));
            LoadedConfig config = this.loadConfig(configLoader);
            if (config != null) {
                properties.putAll((Map<?, ?>)config.getConfigurationValues());
            }
            if ((unit = this.loadPersistenceUnit(classLoaderService, properties)) != null) {
                properties.putAll((Map<?, ?>)unit.getProperties());
            }
            this.configure(properties, tracker);
            if (tracker.track(properties)) {
                this.getLog().debug((CharSequence)"Configuration has changed.");
            } else {
                this.getLog().debug((CharSequence)"Configuration unchanged.");
            }
            final File output = this.getOutputFile(filename);
            this.checkOutputFile(output, tracker);
            final StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder(bootstrapServiceRegitry).applySettings((Map)properties).addService(ConnectionProvider.class, (Service)connectionProvider).build();
            MetadataSources sources = new MetadataSources((ServiceRegistry)serviceRegistry);
            this.completeClassPath(classLoader);
            if (config != null) {
                for (MappingReference mapping : config.getMappingReferences()) {
                    mapping.apply(sources);
                }
            }
            if (unit == null) {
                if (this.scanClasses == null) {
                    this.scanClasses = true;
                }
                urls = new HashSet<URL>();
                if (this.scanClasses.booleanValue()) {
                    this.addRoot((Set<URL>)urls, this.outputDirectory);
                }
                if (this.scanTestClasses.booleanValue()) {
                    this.addRoot((Set<URL>)urls, this.testOutputDirectory);
                }
                this.addDependencies((Set<URL>)urls);
                classes = this.scanUrls((Set<URL>)urls);
            } else {
                if (this.scanClasses == null) {
                    this.scanClasses = !unit.isExcludeUnlistedClasses();
                }
                urls = new HashSet();
                if (this.scanClasses.booleanValue()) {
                    urls.add(unit.getPersistenceUnitRootUrl());
                    for (URL url : unit.getJarFileUrls()) {
                        urls.add(url);
                    }
                }
                if (this.scanTestClasses.booleanValue()) {
                    this.addRoot((Set<URL>)urls, this.testOutputDirectory);
                }
                classes = this.scanUrls((Set<URL>)urls);
                for (String className : unit.getManagedClassNames()) {
                    classes.add(className);
                }
                boolean error = false;
                InputStream is = classLoader.getResourceAsStream("META-INF/orm.xml");
                if (is != null) {
                    this.getLog().info((CharSequence)"Adding default JPA-XML-mapping from META-INF/orm.xml");
                    try {
                        tracker.track("META-INF/orm.xml", is);
                        sources.addResource("META-INF/orm.xml");
                    }
                    catch (IOException e) {
                        this.getLog().error((CharSequence)("cannot read META-INF/orm.xml: " + e));
                        error = true;
                    }
                } else {
                    this.getLog().debug((CharSequence)"no META-INF/orm.xml found");
                }
                for (String mapping : unit.getMappingFileNames()) {
                    this.getLog().info((CharSequence)("Adding explicitly configured mapping from " + mapping));
                    is = classLoader.getResourceAsStream(mapping);
                    if (is != null) {
                        try {
                            tracker.track(mapping, is);
                            sources.addResource(mapping);
                        }
                        catch (IOException e) {
                            this.getLog().info((CharSequence)("cannot read mapping-file " + mapping + ": " + e));
                            error = true;
                        }
                        continue;
                    }
                    this.getLog().error((CharSequence)("cannot find mapping-file " + mapping));
                    error = true;
                }
                if (error) {
                    throw new MojoFailureException("error, while reading mappings configured in persistence-unit \"" + unit.getName() + "\"");
                }
            }
            for (String className : classes) {
                this.addAnnotated(className, sources, classLoaderService, tracker);
            }
            this.addMappings(sources, tracker);
            if (!tracker.modified()) {
                this.getLog().info((CharSequence)"Mapping and configuration unchanged.");
                if (this.force) {
                    this.getLog().info((CharSequence)"Generation/execution is forced!");
                } else {
                    this.getLog().info((CharSequence)"Skipping schema generation!");
                    this.project.getProperties().setProperty(SKIPPED, "true");
                    return;
                }
            }
            try {
                new FileOutputStream(output).getChannel().truncate(0L).close();
            }
            catch (IOException e) {
                String error = "Error while truncating " + output.getAbsolutePath() + ": " + e.getMessage();
                this.getLog().warn((CharSequence)error);
                throw new MojoExecutionException(error);
            }
            connectionProvider.open(classLoaderService, properties);
            MetadataBuilder metadataBuilder = sources.getMetadataBuilder();
            StrategySelector strategySelector = (StrategySelector)serviceRegistry.getService(StrategySelector.class);
            if (properties.containsKey("hibernate.implicit_naming_strategy")) {
                metadataBuilder.applyImplicitNamingStrategy((ImplicitNamingStrategy)strategySelector.resolveStrategy(ImplicitNamingStrategy.class, (Object)properties.getProperty("hibernate.implicit_naming_strategy")));
            }
            if (properties.containsKey("hibernate.physical_naming_strategy")) {
                metadataBuilder.applyPhysicalNamingStrategy((PhysicalNamingStrategy)strategySelector.resolveStrategy(PhysicalNamingStrategy.class, (Object)properties.getProperty("hibernate.physical_naming_strategy")));
            }
            HashMap settings = new HashMap();
            settings.putAll(((ConfigurationService)serviceRegistry.getService(ConfigurationService.class)).getSettings());
            ExceptionHandlerCollectingImpl handler = new ExceptionHandlerCollectingImpl();
            ExecutionOptions options = SchemaManagementToolCoordinator.buildExecutionOptions(settings, (ExceptionHandler)handler);
            final EnumSet<TargetType> targetTypes = EnumSet.of(TargetType.SCRIPT);
            if (this.execute.booleanValue()) {
                targetTypes.add(TargetType.DATABASE);
            }
            TargetDescriptor target = new TargetDescriptor(){

                public EnumSet<TargetType> getTargetTypes() {
                    return targetTypes;
                }

                public ScriptTargetOutput getScriptTargetOutput() {
                    String charset = (String)((ConfigurationService)serviceRegistry.getService(ConfigurationService.class)).getSettings().get("hibernate.hbm2ddl.charset_name");
                    return new ScriptTargetOutputToFile(output, charset);
                }
            };
            Thread thread = Thread.currentThread();
            ClassLoader contextClassLoader = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(classLoader);
                this.build((MetadataImplementor)metadataBuilder.build(), options, target);
                if (handler.getExceptions().size() > 0) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("Hibernate failed:");
                    for (Exception e : handler.getExceptions()) {
                        builder.append("\n * ");
                        builder.append(e.getMessage());
                        AbstractSchemaMojo.printStrackTrace(builder, e);
                        builder.append("\n");
                    }
                    String error = builder.toString();
                    this.getLog().error((CharSequence)error);
                    throw new MojoFailureException(error);
                }
            }
            finally {
                thread.setContextClassLoader(contextClassLoader);
                this.checkOutputFile(output, tracker);
            }
        }
        catch (MojoExecutionException e) {
            tracker.failed();
            throw e;
        }
        catch (MojoFailureException e) {
            tracker.failed();
            throw e;
        }
        catch (RuntimeException e) {
            tracker.failed();
            throw e;
        }
        finally {
            tracker.save();
            connectionProvider.close();
            MavenLogAppender.endPluginLog((AbstractMojo)this);
        }
    }

    abstract void build(MetadataImplementor var1, ExecutionOptions var2, TargetDescriptor var3) throws MojoFailureException, MojoExecutionException;

    private MutableClassLoader createClassLoader() throws MojoExecutionException {
        try {
            this.getLog().debug((CharSequence)"Creating ClassLoader for project-dependencies...");
            LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
            File file = new File(this.testOutputDirectory);
            if (!file.exists()) {
                this.getLog().info((CharSequence)("Creating test-output-directory: " + this.testOutputDirectory));
                file.mkdirs();
            }
            urls.add(file.toURI().toURL());
            file = new File(this.outputDirectory);
            if (!file.exists()) {
                this.getLog().info((CharSequence)("Creating output-directory: " + this.outputDirectory));
                file.mkdirs();
            }
            urls.add(file.toURI().toURL());
            return new MutableClassLoader(urls, this.getLog());
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error while creating ClassLoader!", (Throwable)e);
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private void completeClassPath(MutableClassLoader classLoader) throws MojoExecutionException {
        try {
            this.getLog().debug((CharSequence)"Completing class-paths of the ClassLoader for project-dependencies...");
            List classpathFiles = this.project.getCompileClasspathElements();
            if (this.scanTestClasses.booleanValue()) {
                classpathFiles.addAll(this.project.getTestClasspathElements());
            }
            LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
            for (String pathElement : classpathFiles) {
                this.getLog().debug((CharSequence)("Dependency: " + pathElement));
                urls.add(new File(pathElement).toURI().toURL());
            }
            classLoader.add(urls);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error while creating ClassLoader!", (Throwable)e);
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private Map loadProperties(ConfigLoader configLoader) throws MojoExecutionException {
        if (this.hibernateProperties == null) {
            try {
                return configLoader.loadProperties("hibernate.properties");
            }
            catch (ConfigurationException e) {
                this.getLog().debug((CharSequence)e.getMessage());
                return Collections.EMPTY_MAP;
            }
        }
        try {
            File file = new File(this.hibernateProperties);
            if (file.exists()) {
                this.getLog().info((CharSequence)("Reading settings from file " + this.hibernateProperties + "..."));
                return configLoader.loadProperties(file);
            }
            return configLoader.loadProperties(this.hibernateProperties);
        }
        catch (ConfigurationException e) {
            this.getLog().error((CharSequence)"Error while reading properties!", (Throwable)e);
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private LoadedConfig loadConfig(ConfigLoader configLoader) throws MojoExecutionException {
        if (this.hibernateConfig == null) {
            try {
                return configLoader.loadConfigXmlResource("hibernate.cfg.xml");
            }
            catch (ConfigurationException e) {
                this.getLog().debug((CharSequence)e.getMessage());
                return null;
            }
        }
        try {
            File file = new File(this.hibernateConfig);
            if (file.exists()) {
                this.getLog().info((CharSequence)("Reading configuration from file " + this.hibernateConfig + "..."));
                return configLoader.loadConfigXmlFile(file);
            }
            return configLoader.loadConfigXmlResource(this.hibernateConfig);
        }
        catch (ConfigurationException e) {
            this.getLog().error((CharSequence)"Error while reading configuration!", (Throwable)e);
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private void configure(Properties properties, ModificationTracker tracker) throws MojoFailureException {
        if (tracker.check(EXECUTE, this.execute.toString()) && this.execute.booleanValue()) {
            this.getLog().info((CharSequence)"hibernate.schema.execute was switched on: forcing generation/execution of SQL");
            tracker.touch();
        }
        this.configure(properties, this.execute, EXECUTE);
        this.configure(properties, this.dialect, "hibernate.dialect");
        this.configure(properties, this.delimiter, "hibernate.hbm2ddl.delimiter");
        this.configure(properties, this.format, "hibernate.format_sql");
        this.configure(properties, this.createNamespaces, "hibernate.hbm2dll.create_namespaces");
        this.configure(properties, this.implicitNamingStrategy, "hibernate.implicit_naming_strategy");
        this.configure(properties, this.physicalNamingStrategy, "hibernate.physical_naming_strategy");
        this.configure(properties, this.outputDirectory, OUTPUTDIRECTORY);
        this.configure(properties, this.scanDependencies, SCAN_DEPENDENCIES);
        this.configure(properties, this.scanTestClasses, SCAN_TESTCLASSES);
        this.configure(properties, this.testOutputDirectory, TEST_OUTPUTDIRECTORY);
        if (this.show == null) {
            this.show = Boolean.valueOf(properties.getProperty("hibernate.show_sql"));
        } else {
            properties.setProperty("hibernate.show_sql", this.show.toString());
        }
        this.configure(properties, this.driver, "hibernate.connection.driver_class", "javax.persistence.jdbc.driver");
        this.configure(properties, this.url, "hibernate.connection.url", "javax.persistence.jdbc.url");
        this.configure(properties, this.username, "hibernate.connection.username", "javax.persistence.jdbc.user");
        this.configure(properties, this.password, "hibernate.connection.password", "javax.persistence.jdbc.password");
        if (properties.isEmpty()) {
            this.getLog().error((CharSequence)"No properties set!");
            throw new MojoFailureException("Hibernate configuration is missing!");
        }
        this.getLog().info((CharSequence)"Gathered configuration:");
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.getLog().info((CharSequence)("  " + entry.getKey() + " = " + entry.getValue()));
        }
    }

    private void configure(Properties properties, String value, String key, String alternativeKey) {
        this.configure(properties, value, key);
        if (properties.containsKey(alternativeKey)) {
            if (properties.containsKey(key)) {
                this.getLog().warn((CharSequence)("Ignoring property " + alternativeKey + "=\"" + properties.getProperty(alternativeKey) + "\" in favour for property " + key + "=\"" + properties.getProperty(key) + "\""));
                properties.remove(alternativeKey);
            } else {
                value = properties.getProperty(alternativeKey);
                properties.remove(alternativeKey);
                this.getLog().info((CharSequence)("Using value \"" + value + "\" from property " + alternativeKey + " for property " + key));
                properties.setProperty(key, value);
            }
        }
    }

    private void configure(Properties properties, String value, String key) {
        if (value != null) {
            if (properties.containsKey(key)) {
                if (!properties.getProperty(key).equals(value)) {
                    this.getLog().info((CharSequence)("Overwriting property " + key + "=\"" + properties.getProperty(key) + "\" with value \"" + value + "\""));
                    properties.setProperty(key, value);
                }
            } else {
                this.getLog().debug((CharSequence)("Using value \"" + value + "\" for property " + key));
                properties.setProperty(key, value);
            }
        }
    }

    private void configure(Properties properties, Boolean value, String key) {
        this.configure(properties, value == null ? null : value.toString(), key);
    }

    private File getOutputFile(String filename) throws MojoExecutionException {
        File output = new File(filename);
        if (!output.isAbsolute()) {
            output = new File(this.buildDirectory, filename);
        }
        this.getLog().debug((CharSequence)("Output file: " + output.getPath()));
        File outFileParentDir = output.getParentFile();
        if (null != outFileParentDir && !outFileParentDir.exists()) {
            try {
                this.getLog().info((CharSequence)("Creating directory path for output file:" + outFileParentDir.getPath()));
                outFileParentDir.mkdirs();
            }
            catch (Exception e) {
                String error = "Error creating directory path for output file: " + e.getMessage();
                this.getLog().error((CharSequence)error);
                throw new MojoExecutionException(error);
            }
        }
        try {
            output.createNewFile();
        }
        catch (IOException e) {
            String error = "Error creating output file: " + e.getMessage();
            this.getLog().error((CharSequence)error);
            throw new MojoExecutionException(error);
        }
        if (!output.canWrite()) {
            String error = "Output file " + output.getAbsolutePath() + " is not writable!";
            this.getLog().error((CharSequence)error);
            throw new MojoExecutionException(error);
        }
        return output;
    }

    private void checkOutputFile(File output, ModificationTracker tracker) throws MojoExecutionException {
        try {
            if (output.exists()) {
                tracker.track(SCRIPT, new FileInputStream(output));
            } else {
                tracker.track(SCRIPT, ZonedDateTime.now().toString());
            }
        }
        catch (IOException e) {
            String error = "Error while checking the generated script: " + e.getMessage();
            this.getLog().error((CharSequence)error);
            throw new MojoExecutionException(error);
        }
    }

    private void addMappings(MetadataSources sources, ModificationTracker tracker) throws MojoFailureException {
        this.getLog().debug((CharSequence)"Adding explicitly configured mappings...");
        if (this.mappings != null) {
            try {
                for (String filename : this.mappings.split("[\\s,]+")) {
                    File file = new File(filename);
                    if (!file.exists()) {
                        Resource resource;
                        Iterator iterator = this.project.getResources().iterator();
                        while (iterator.hasNext() && !(file = new File((resource = (Resource)iterator.next()).getDirectory() + File.separator + filename)).exists()) {
                        }
                    }
                    if (file.exists()) {
                        if (file.isDirectory()) {
                            throw new MojoFailureException(file.getAbsolutePath() + " is a directory");
                        }
                        if (tracker.track(filename, new FileInputStream(file))) {
                            this.getLog().debug((CharSequence)("Found new or modified mapping-file: " + filename));
                        } else {
                            this.getLog().debug((CharSequence)("Mapping-file unchanged: " + filename));
                        }
                    } else {
                        throw new MojoFailureException("File " + filename + " could not be found in any of the configured resource-directories!");
                    }
                    sources.addFile(file);
                }
            }
            catch (IOException e) {
                throw new MojoFailureException("Cannot calculate MD5 sums!", (Throwable)e);
            }
        }
    }

    private void addRoot(Set<URL> urls, String path) throws MojoFailureException {
        try {
            File dir = new File(path);
            if (dir.exists()) {
                this.getLog().info((CharSequence)("Adding " + dir.getAbsolutePath() + " to the list of roots to scan..."));
                urls.add(dir.toURI().toURL());
            } else {
                this.getLog().warn((CharSequence)("the directory cannot be scanned for annotated classes, because it does not exist: " + dir.getAbsolutePath()));
            }
        }
        catch (MalformedURLException e) {
            this.getLog().error((CharSequence)"error while adding the project-root to the list of roots to scan!", (Throwable)e);
            throw new MojoFailureException(e.getMessage());
        }
    }

    private void addDependencies(Set<URL> urls) throws MojoFailureException {
        try {
            if (this.scanDependencies != null) {
                Matcher matcher = SPLIT.matcher(this.scanDependencies);
                while (matcher.find()) {
                    this.getLog().info((CharSequence)("Adding dependencies from scope " + matcher.group() + " to the list of roots to scan"));
                    for (Artifact artifact : this.project.getDependencyArtifacts()) {
                        if (!artifact.getScope().equalsIgnoreCase(matcher.group())) continue;
                        if (artifact.getFile() == null) {
                            this.getLog().warn((CharSequence)("Cannot add dependency " + artifact.getId() + ": no JAR-file available!"));
                            continue;
                        }
                        this.getLog().info((CharSequence)("Adding dependencies from scope " + artifact.getId() + " to the list of roots to scan"));
                        urls.add(artifact.getFile().toURI().toURL());
                    }
                }
            }
        }
        catch (MalformedURLException e) {
            this.getLog().error((CharSequence)"Error while adding dependencies to the list of roots to scan!", (Throwable)e);
            throw new MojoFailureException(e.getMessage());
        }
    }

    private Set<String> scanUrls(Set<URL> scanRoots) throws MojoFailureException {
        try {
            AnnotationDB db = new AnnotationDB();
            for (URL root : scanRoots) {
                db.scanArchives(new URL[]{root});
            }
            HashSet<String> classes = new HashSet<String>();
            if (db.getAnnotationIndex().containsKey(Entity.class.getName())) {
                classes.addAll((Collection)db.getAnnotationIndex().get(Entity.class.getName()));
            }
            if (db.getAnnotationIndex().containsKey(MappedSuperclass.class.getName())) {
                classes.addAll((Collection)db.getAnnotationIndex().get(MappedSuperclass.class.getName()));
            }
            if (db.getAnnotationIndex().containsKey(Embeddable.class.getName())) {
                classes.addAll((Collection)db.getAnnotationIndex().get(Embeddable.class.getName()));
            }
            return classes;
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error while scanning!", (Throwable)e);
            throw new MojoFailureException(e.getMessage());
        }
    }

    private void addAnnotated(String name, MetadataSources sources, ClassLoaderService classLoaderService, ModificationTracker tracker) throws MojoFailureException, MojoExecutionException {
        try {
            this.getLog().info((CharSequence)("Adding annotated resource: " + name));
            String packageName = null;
            boolean error = false;
            try {
                Class annotatedClass = classLoaderService.classForName(name);
                String resourceName = annotatedClass.getName();
                resourceName = resourceName.substring(resourceName.lastIndexOf(".") + 1, resourceName.length()) + ".class";
                InputStream is = annotatedClass.getResourceAsStream(resourceName);
                if (is != null) {
                    if (tracker.track(name, is)) {
                        this.getLog().debug((CharSequence)("New or modified class: " + name));
                    } else {
                        this.getLog().debug((CharSequence)("Unchanged class: " + name));
                    }
                    sources.addAnnotatedClass(annotatedClass);
                    packageName = annotatedClass.getPackage().getName();
                } else {
                    this.getLog().error((CharSequence)("cannot find ressource " + resourceName + " for class " + name));
                    error = true;
                }
            }
            catch (ClassLoadingException e) {
                packageName = name;
            }
            if (error) {
                throw new MojoExecutionException("error while inspecting annotated class " + name);
            }
            while (packageName != null) {
                if (this.packages.contains(packageName)) {
                    return;
                }
                String resource = packageName.replace('.', '/') + "/package-info.class";
                InputStream is = classLoaderService.locateResourceStream(resource);
                if (is == null) {
                    this.getLog().debug((CharSequence)("Package " + packageName + " is not annotated."));
                } else {
                    if (tracker.track(packageName, is)) {
                        this.getLog().debug((CharSequence)("New or modified package: " + packageName));
                    } else {
                        this.getLog().debug((CharSequence)("Unchanged package: " + packageName));
                    }
                    this.getLog().info((CharSequence)("Adding annotations from package " + packageName));
                    sources.addPackage(packageName);
                }
                this.packages.add(packageName);
                int i = packageName.lastIndexOf(46);
                if (i < 0) {
                    packageName = null;
                    continue;
                }
                packageName = packageName.substring(0, i);
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Error while adding the annotated class " + name), (Throwable)e);
            throw new MojoFailureException(e.getMessage());
        }
    }

    private ParsedPersistenceXmlDescriptor loadPersistenceUnit(ClassLoaderService classLoaderService, Properties properties) throws MojoFailureException {
        PersistenceXmlParser parser = new PersistenceXmlParser(classLoaderService, PersistenceUnitTransactionType.RESOURCE_LOCAL);
        Map units = parser.doResolve((Map)properties);
        if (this.persistenceUnit == null) {
            Iterator names = units.keySet().iterator();
            if (!names.hasNext()) {
                this.getLog().info((CharSequence)"Found no META-INF/persistence.xml.");
                return null;
            }
            String name = (String)names.next();
            if (!names.hasNext()) {
                this.getLog().info((CharSequence)("Using persistence-unit " + name));
                return (ParsedPersistenceXmlDescriptor)units.get(name);
            }
            StringBuilder builder = new StringBuilder();
            builder.append("No name provided and multiple persistence units found: ");
            builder.append(name);
            while (names.hasNext()) {
                builder.append(", ");
                builder.append((String)names.next());
            }
            builder.append('.');
            throw new MojoFailureException(builder.toString());
        }
        if (units.containsKey(this.persistenceUnit)) {
            this.getLog().info((CharSequence)("Using configured persistence-unit " + this.persistenceUnit));
            return (ParsedPersistenceXmlDescriptor)units.get(this.persistenceUnit);
        }
        throw new MojoFailureException("Could not find persistence-unit " + this.persistenceUnit);
    }

    public static void printStrackTrace(StringBuilder builder, Throwable t) {
        while (t != null) {
            builder.append("\n\tCause: ");
            builder.append(t.getMessage() == null ? "" : t.getMessage().replaceAll("\\s+", " "));
            for (StackTraceElement trace : t.getStackTrace()) {
                builder.append("\n\t");
                builder.append(trace.getClassName());
                builder.append(".");
                builder.append(trace.getMethodName());
                builder.append("():");
                builder.append(trace.getLineNumber());
            }
            t = t.getCause();
        }
    }
}

