/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.dialect.oracle.clause;

import com.google.common.base.Optional;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.parser.clause.WhereClauseParser;
import io.shardingsphere.core.parsing.parser.context.selectitem.SelectItem;
import java.util.List;

public final class OracleWhereClauseParser
extends WhereClauseParser {
    public OracleWhereClauseParser(LexerEngine lexerEngine) {
        super(DatabaseType.Oracle, lexerEngine);
    }

    @Override
    protected boolean isRowNumberCondition(List<SelectItem> items, String columnLabel) {
        Optional<String> rowNumberAlias = Optional.absent();
        for (SelectItem each : items) {
            if (!each.getAlias().isPresent() || !"rownum".equalsIgnoreCase(each.getExpression())) continue;
            rowNumberAlias = each.getAlias();
            break;
        }
        return "rownum".equalsIgnoreCase(columnLabel) || columnLabel.equalsIgnoreCase((String)rowNumberAlias.orNull());
    }
}

