/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.sql.dml.insert;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.metadata.ShardingMetaData;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.parser.dialect.mysql.sql.MySQLInsertParser;
import io.shardingsphere.core.parsing.parser.dialect.oracle.sql.OracleInsertParser;
import io.shardingsphere.core.parsing.parser.dialect.postgresql.sql.PostgreSQLInsertParser;
import io.shardingsphere.core.parsing.parser.dialect.sqlserver.sql.SQLServerInsertParser;
import io.shardingsphere.core.parsing.parser.sql.dml.insert.AbstractInsertParser;
import io.shardingsphere.core.rule.ShardingRule;

public final class InsertParserFactory {
    public static AbstractInsertParser newInstance(DatabaseType dbType, ShardingRule shardingRule, LexerEngine lexerEngine, ShardingMetaData shardingMetaData) {
        switch (dbType) {
            case H2: 
            case MySQL: {
                return new MySQLInsertParser(shardingRule, lexerEngine, shardingMetaData);
            }
            case Oracle: {
                return new OracleInsertParser(shardingRule, lexerEngine, shardingMetaData);
            }
            case SQLServer: {
                return new SQLServerInsertParser(shardingRule, lexerEngine, shardingMetaData);
            }
            case PostgreSQL: {
                return new PostgreSQLInsertParser(shardingRule, lexerEngine, shardingMetaData);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database [%s].", new Object[]{dbType}));
    }

    private InsertParserFactory() {
    }
}

