/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.routing;

import io.shardingsphere.core.constant.SQLType;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.routing.SQLExecutionUnit;
import io.shardingsphere.core.routing.router.sharding.GeneratedKey;
import java.beans.ConstructorProperties;
import java.util.LinkedHashSet;
import java.util.Set;

public final class SQLRouteResult {
    private final SQLStatement sqlStatement;
    private final GeneratedKey generatedKey;
    private final Set<SQLExecutionUnit> executionUnits = new LinkedHashSet<SQLExecutionUnit>();

    public boolean canRefreshMetaData() {
        return SQLType.DDL.equals((Object)this.sqlStatement.getType()) && !this.sqlStatement.getTables().isEmpty();
    }

    @ConstructorProperties(value={"sqlStatement", "generatedKey"})
    public SQLRouteResult(SQLStatement sqlStatement, GeneratedKey generatedKey) {
        this.sqlStatement = sqlStatement;
        this.generatedKey = generatedKey;
    }

    public SQLStatement getSqlStatement() {
        return this.sqlStatement;
    }

    public GeneratedKey getGeneratedKey() {
        return this.generatedKey;
    }

    public Set<SQLExecutionUnit> getExecutionUnits() {
        return this.executionUnits;
    }
}

