/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.rule;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.shardingsphere.core.api.config.MasterSlaveRuleConfiguration;
import io.shardingsphere.core.api.config.ShardingRuleConfiguration;
import io.shardingsphere.core.api.config.TableRuleConfiguration;
import io.shardingsphere.core.exception.ShardingConfigurationException;
import io.shardingsphere.core.keygen.DefaultKeyGenerator;
import io.shardingsphere.core.keygen.KeyGenerator;
import io.shardingsphere.core.parsing.parser.context.condition.Column;
import io.shardingsphere.core.routing.strategy.ShardingStrategy;
import io.shardingsphere.core.routing.strategy.ShardingStrategyFactory;
import io.shardingsphere.core.routing.strategy.none.NoneShardingStrategy;
import io.shardingsphere.core.rule.BindingTableRule;
import io.shardingsphere.core.rule.DataNode;
import io.shardingsphere.core.rule.MasterSlaveRule;
import io.shardingsphere.core.rule.ShardingDataSourceNames;
import io.shardingsphere.core.rule.TableRule;
import io.shardingsphere.core.util.StringUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.TreeSet;

public final class ShardingRule {
    private final ShardingRuleConfiguration shardingRuleConfig;
    private final ShardingDataSourceNames shardingDataSourceNames;
    private final Collection<TableRule> tableRules = new LinkedList<TableRule>();
    private final Collection<BindingTableRule> bindingTableRules = new LinkedList<BindingTableRule>();
    private final ShardingStrategy defaultDatabaseShardingStrategy;
    private final ShardingStrategy defaultTableShardingStrategy;
    private final KeyGenerator defaultKeyGenerator;
    private final Collection<MasterSlaveRule> masterSlaveRules = new LinkedList<MasterSlaveRule>();

    public ShardingRule(ShardingRuleConfiguration shardingRuleConfig, Collection<String> dataSourceNames) {
        Preconditions.checkNotNull(dataSourceNames, (Object)"Data sources cannot be null.");
        Preconditions.checkArgument((!dataSourceNames.isEmpty() ? 1 : 0) != 0, (Object)"Data sources cannot be empty.");
        this.shardingRuleConfig = shardingRuleConfig;
        this.shardingDataSourceNames = new ShardingDataSourceNames(shardingRuleConfig, dataSourceNames);
        for (TableRuleConfiguration tableRuleConfiguration : shardingRuleConfig.getTableRuleConfigs()) {
            this.tableRules.add(new TableRule(tableRuleConfiguration, this.shardingDataSourceNames));
        }
        for (String string : shardingRuleConfig.getBindingTableGroups()) {
            LinkedList<TableRule> tableRulesForBinding = new LinkedList<TableRule>();
            for (String logicTableNameForBindingTable : StringUtil.splitWithComma(string)) {
                tableRulesForBinding.add(this.getTableRule(logicTableNameForBindingTable));
            }
            this.bindingTableRules.add(new BindingTableRule(tableRulesForBinding));
        }
        this.defaultDatabaseShardingStrategy = null == shardingRuleConfig.getDefaultDatabaseShardingStrategyConfig() ? new NoneShardingStrategy() : ShardingStrategyFactory.newInstance(shardingRuleConfig.getDefaultDatabaseShardingStrategyConfig());
        this.defaultTableShardingStrategy = null == shardingRuleConfig.getDefaultTableShardingStrategyConfig() ? new NoneShardingStrategy() : ShardingStrategyFactory.newInstance(shardingRuleConfig.getDefaultTableShardingStrategyConfig());
        this.defaultKeyGenerator = null == shardingRuleConfig.getDefaultKeyGenerator() ? new DefaultKeyGenerator() : shardingRuleConfig.getDefaultKeyGenerator();
        for (MasterSlaveRuleConfiguration masterSlaveRuleConfiguration : shardingRuleConfig.getMasterSlaveRuleConfigs()) {
            this.masterSlaveRules.add(new MasterSlaveRule(masterSlaveRuleConfiguration));
        }
    }

    public Optional<TableRule> tryFindTableRuleByLogicTable(String logicTableName) {
        for (TableRule each : this.tableRules) {
            if (!each.getLogicTable().equals(logicTableName.toLowerCase())) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    public Optional<TableRule> tryFindTableRuleByActualTable(String actualTableName) {
        for (TableRule each : this.tableRules) {
            if (!each.isExisted(actualTableName)) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    public TableRule getTableRule(String logicTableName) {
        Optional<TableRule> tableRule = this.tryFindTableRuleByLogicTable(logicTableName.toLowerCase());
        if (tableRule.isPresent()) {
            return (TableRule)tableRule.get();
        }
        if (!Strings.isNullOrEmpty((String)this.shardingDataSourceNames.getDefaultDataSourceName())) {
            return this.createTableRuleWithDefaultDataSource(logicTableName.toLowerCase());
        }
        throw new ShardingConfigurationException("Cannot find table rule and default data source with logic table: '%s'", logicTableName);
    }

    private TableRule createTableRuleWithDefaultDataSource(String logicTableName) {
        TableRuleConfiguration tableRuleConfig = new TableRuleConfiguration();
        tableRuleConfig.setLogicTable(logicTableName);
        tableRuleConfig.setActualDataNodes(this.shardingDataSourceNames.getDefaultDataSourceName() + "." + logicTableName);
        return new TableRule(tableRuleConfig, new ShardingDataSourceNames(this.shardingRuleConfig, Collections.singletonList(this.shardingDataSourceNames.getDefaultDataSourceName())));
    }

    public ShardingStrategy getDatabaseShardingStrategy(TableRule tableRule) {
        return null == tableRule.getDatabaseShardingStrategy() ? this.defaultDatabaseShardingStrategy : tableRule.getDatabaseShardingStrategy();
    }

    public ShardingStrategy getTableShardingStrategy(TableRule tableRule) {
        return null == tableRule.getTableShardingStrategy() ? this.defaultTableShardingStrategy : tableRule.getTableShardingStrategy();
    }

    public boolean isAllBindingTables(Collection<String> logicTables) {
        if (logicTables.isEmpty()) {
            return false;
        }
        Optional<BindingTableRule> bindingTableRule = this.findBindingTableRule(logicTables);
        if (!bindingTableRule.isPresent()) {
            return false;
        }
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.addAll(((BindingTableRule)bindingTableRule.get()).getAllLogicTables());
        return !result.isEmpty() && result.containsAll(logicTables);
    }

    public boolean isAllInDefaultDataSource(Collection<String> logicTables) {
        for (String each : logicTables) {
            if (!this.tryFindTableRuleByLogicTable(each).isPresent()) continue;
            return false;
        }
        return !logicTables.isEmpty();
    }

    private Optional<BindingTableRule> findBindingTableRule(Collection<String> logicTables) {
        for (String each : logicTables) {
            Optional<BindingTableRule> result = this.findBindingTableRule(each);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.absent();
    }

    public Optional<BindingTableRule> findBindingTableRule(String logicTable) {
        for (BindingTableRule each : this.bindingTableRules) {
            if (!each.hasLogicTable(logicTable)) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    public boolean isShardingColumn(Column column) {
        if (this.defaultDatabaseShardingStrategy.getShardingColumns().contains(column.getName()) || this.defaultTableShardingStrategy.getShardingColumns().contains(column.getName())) {
            return true;
        }
        for (TableRule each : this.tableRules) {
            if (!each.getLogicTable().equalsIgnoreCase(column.getTableName())) continue;
            if (null != each.getDatabaseShardingStrategy() && each.getDatabaseShardingStrategy().getShardingColumns().contains(column.getName())) {
                return true;
            }
            if (null == each.getTableShardingStrategy() || !each.getTableShardingStrategy().getShardingColumns().contains(column.getName())) continue;
            return true;
        }
        return false;
    }

    public Optional<Column> getGenerateKeyColumn(String logicTableName) {
        for (TableRule each : this.tableRules) {
            if (!each.getLogicTable().equalsIgnoreCase(logicTableName) || null == each.getGenerateKeyColumn()) continue;
            return Optional.of((Object)new Column(each.getGenerateKeyColumn(), logicTableName));
        }
        return Optional.absent();
    }

    public Number generateKey(String logicTableName) {
        Optional<TableRule> tableRule = this.tryFindTableRuleByLogicTable(logicTableName);
        if (!tableRule.isPresent()) {
            throw new ShardingConfigurationException("Cannot find strategy for generate keys.", new Object[0]);
        }
        if (null != ((TableRule)tableRule.get()).getKeyGenerator()) {
            return ((TableRule)tableRule.get()).getKeyGenerator().generateKey();
        }
        return this.defaultKeyGenerator.generateKey();
    }

    public String getLogicTableName(String logicIndexName) {
        for (TableRule each : this.tableRules) {
            if (!logicIndexName.equals(each.getLogicIndex())) continue;
            return each.getLogicTable();
        }
        throw new ShardingConfigurationException("Cannot find logic table name with logic index name: '%s'", logicIndexName);
    }

    public DataNode findDataNode(String logicTableName) {
        return this.findDataNode(null, logicTableName);
    }

    public DataNode findDataNode(String dataSourceName, String logicTableName) {
        TableRule tableRule = this.getTableRule(logicTableName);
        for (DataNode each : tableRule.getActualDataNodes()) {
            if (!this.shardingDataSourceNames.getDataSourceNames().contains(each.getDataSourceName()) || null != dataSourceName && !each.getDataSourceName().equals(dataSourceName)) continue;
            return each;
        }
        if (null == dataSourceName) {
            throw new ShardingConfigurationException("Cannot find actual data node for logic table name: '%s'", logicTableName);
        }
        throw new ShardingConfigurationException("Cannot find actual data node for data source name: '%s' and logic table name: '%s'", dataSourceName, logicTableName);
    }

    public boolean isLogicIndex(String logicIndexName, String logicTableName) {
        return logicIndexName.equals(this.getTableRule(logicTableName).getLogicIndex());
    }

    public ShardingRuleConfiguration getShardingRuleConfig() {
        return this.shardingRuleConfig;
    }

    public ShardingDataSourceNames getShardingDataSourceNames() {
        return this.shardingDataSourceNames;
    }

    public Collection<TableRule> getTableRules() {
        return this.tableRules;
    }

    public Collection<BindingTableRule> getBindingTableRules() {
        return this.bindingTableRules;
    }

    public ShardingStrategy getDefaultDatabaseShardingStrategy() {
        return this.defaultDatabaseShardingStrategy;
    }

    public ShardingStrategy getDefaultTableShardingStrategy() {
        return this.defaultTableShardingStrategy;
    }

    public KeyGenerator getDefaultKeyGenerator() {
        return this.defaultKeyGenerator;
    }

    public Collection<MasterSlaveRule> getMasterSlaveRules() {
        return this.masterSlaveRules;
    }
}

