/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.executor.sql.execute;

import io.shardingsphere.core.executor.ShardingExecuteEngine;
import io.shardingsphere.core.executor.ShardingExecuteGroup;
import io.shardingsphere.core.executor.StatementExecuteUnit;
import io.shardingsphere.core.executor.sql.execute.SQLExecuteCallback;
import io.shardingsphere.core.executor.sql.execute.threadlocal.ExecutorExceptionHandler;
import java.beans.ConstructorProperties;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class SQLExecuteTemplate {
    private final ShardingExecuteEngine executeEngine;

    public <T> List<T> executeGroup(Collection<ShardingExecuteGroup<? extends StatementExecuteUnit>> sqlExecuteGroups, SQLExecuteCallback<T> callback) throws SQLException {
        return this.executeGroup(sqlExecuteGroups, null, callback);
    }

    public <T> List<T> executeGroup(Collection<ShardingExecuteGroup<? extends StatementExecuteUnit>> sqlExecuteGroups, SQLExecuteCallback<T> firstCallback, SQLExecuteCallback<T> callback) throws SQLException {
        try {
            return this.executeEngine.groupExecute(sqlExecuteGroups, firstCallback, callback);
        }
        catch (SQLException ex) {
            ExecutorExceptionHandler.handleException(ex);
            return Collections.emptyList();
        }
    }

    @ConstructorProperties(value={"executeEngine"})
    public SQLExecuteTemplate(ShardingExecuteEngine executeEngine) {
        this.executeEngine = executeEngine;
    }
}

