/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.clause;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.token.Assist;
import io.shardingsphere.core.parsing.lexer.token.Symbol;
import io.shardingsphere.core.parsing.parser.clause.SQLClauseParser;
import io.shardingsphere.core.parsing.parser.clause.expression.BasicExpressionParser;
import io.shardingsphere.core.parsing.parser.context.condition.Column;
import io.shardingsphere.core.parsing.parser.dialect.ExpressionParserFactory;
import io.shardingsphere.core.parsing.parser.expression.SQLExpression;
import io.shardingsphere.core.parsing.parser.expression.SQLIdentifierExpression;
import io.shardingsphere.core.parsing.parser.expression.SQLIgnoreExpression;
import io.shardingsphere.core.parsing.parser.expression.SQLPropertyExpression;
import io.shardingsphere.core.parsing.parser.sql.dml.insert.InsertStatement;
import io.shardingsphere.core.parsing.parser.token.InsertColumnToken;
import io.shardingsphere.core.parsing.parser.token.ItemsToken;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.core.util.SQLUtil;
import java.util.Collection;
import java.util.LinkedList;

public final class InsertColumnsClauseParser
implements SQLClauseParser {
    private final ShardingRule shardingRule;
    private final LexerEngine lexerEngine;
    private final BasicExpressionParser basicExpressionParser;

    public InsertColumnsClauseParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
        this.basicExpressionParser = ExpressionParserFactory.createBasicExpressionParser(lexerEngine);
    }

    public void parse(InsertStatement insertStatement, ShardingTableMetaData shardingTableMetaData) {
        String tableName = insertStatement.getTables().getSingleTableName();
        Optional<Column> generateKeyColumn = this.shardingRule.getGenerateKeyColumn(tableName);
        insertStatement.getColumns().addAll(this.lexerEngine.equalAny(Symbol.LEFT_PAREN) ? this.parseWithColumn(insertStatement, tableName, generateKeyColumn) : this.parseWithoutColumn(insertStatement, shardingTableMetaData, tableName, generateKeyColumn));
    }

    private Collection<Column> parseWithColumn(InsertStatement insertStatement, String tableName, Optional<Column> generateKeyColumn) {
        int count = 0;
        LinkedList<Column> result = new LinkedList<Column>();
        do {
            this.lexerEngine.nextToken();
            SQLExpression sqlExpression = this.basicExpressionParser.parse(insertStatement);
            String columnName = null;
            if (sqlExpression instanceof SQLPropertyExpression) {
                columnName = SQLUtil.getExactlyValue(((SQLPropertyExpression)sqlExpression).getName());
            }
            if (sqlExpression instanceof SQLIdentifierExpression) {
                columnName = SQLUtil.getExactlyValue(((SQLIdentifierExpression)sqlExpression).getName());
            }
            if (sqlExpression instanceof SQLIgnoreExpression) {
                columnName = SQLUtil.getExactlyValue(((SQLIgnoreExpression)sqlExpression).getExpression());
            }
            Preconditions.checkNotNull((Object)columnName);
            result.add(new Column(columnName, tableName));
            if (generateKeyColumn.isPresent() && ((Column)generateKeyColumn.get()).getName().equalsIgnoreCase(columnName)) {
                insertStatement.setGenerateKeyColumnIndex(count);
            }
            ++count;
        } while (!this.lexerEngine.equalAny(Symbol.RIGHT_PAREN) && !this.lexerEngine.equalAny(Assist.END));
        insertStatement.setColumnsListLastPosition(this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length());
        this.lexerEngine.nextToken();
        return result;
    }

    private Collection<Column> parseWithoutColumn(InsertStatement insertStatement, ShardingTableMetaData shardingTableMetaData, String tableName, Optional<Column> generateKeyColumn) {
        int count = 0;
        int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length() - 1;
        insertStatement.addSQLToken(new InsertColumnToken(beginPosition, "("));
        ItemsToken columnsToken = new ItemsToken(beginPosition);
        columnsToken.setFirstOfItemsSpecial(true);
        LinkedList<Column> result = new LinkedList<Column>();
        if (shardingTableMetaData.containsTable(tableName)) {
            for (String each : shardingTableMetaData.getAllColumnNames(tableName)) {
                result.add(new Column(each, tableName));
                if (generateKeyColumn.isPresent() && ((Column)generateKeyColumn.get()).getName().equalsIgnoreCase(each)) {
                    insertStatement.setGenerateKeyColumnIndex(count);
                }
                columnsToken.getItems().add(each);
                ++count;
            }
        }
        insertStatement.addSQLToken(columnsToken);
        insertStatement.addSQLToken(new InsertColumnToken(beginPosition, ")"));
        insertStatement.setColumnsListLastPosition(beginPosition);
        return result;
    }
}

