/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.clause;

import com.google.common.base.Optional;
import io.shardingsphere.core.exception.ShardingException;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.lexer.token.Keyword;
import io.shardingsphere.core.parsing.lexer.token.Symbol;
import io.shardingsphere.core.parsing.parser.clause.SQLClauseParser;
import io.shardingsphere.core.parsing.parser.clause.expression.BasicExpressionParser;
import io.shardingsphere.core.parsing.parser.context.condition.AndCondition;
import io.shardingsphere.core.parsing.parser.context.condition.Column;
import io.shardingsphere.core.parsing.parser.context.condition.Condition;
import io.shardingsphere.core.parsing.parser.context.condition.GeneratedKeyCondition;
import io.shardingsphere.core.parsing.parser.context.insertvalue.InsertValue;
import io.shardingsphere.core.parsing.parser.dialect.ExpressionParserFactory;
import io.shardingsphere.core.parsing.parser.exception.SQLParsingException;
import io.shardingsphere.core.parsing.parser.expression.SQLExpression;
import io.shardingsphere.core.parsing.parser.expression.SQLNumberExpression;
import io.shardingsphere.core.parsing.parser.expression.SQLPlaceholderExpression;
import io.shardingsphere.core.parsing.parser.expression.SQLTextExpression;
import io.shardingsphere.core.parsing.parser.sql.dml.insert.InsertStatement;
import io.shardingsphere.core.parsing.parser.token.InsertValuesToken;
import io.shardingsphere.core.parsing.parser.token.ItemsToken;
import io.shardingsphere.core.rule.ShardingRule;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public abstract class InsertValuesClauseParser
implements SQLClauseParser {
    private final ShardingRule shardingRule;
    private final LexerEngine lexerEngine;
    private final BasicExpressionParser basicExpressionParser;

    public InsertValuesClauseParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
        this.basicExpressionParser = ExpressionParserFactory.createBasicExpressionParser(lexerEngine);
    }

    public void parse(InsertStatement insertStatement) {
        LinkedList<Keyword> valueKeywords = new LinkedList<Keyword>();
        valueKeywords.add(DefaultKeyword.VALUES);
        valueKeywords.addAll(Arrays.asList(this.getSynonymousKeywordsForValues()));
        if (this.lexerEngine.skipIfEqual(valueKeywords.toArray(new Keyword[valueKeywords.size()]))) {
            this.parseValues(insertStatement);
        }
    }

    protected abstract Keyword[] getSynonymousKeywordsForValues();

    private void parseValues(InsertStatement insertStatement) {
        int endPosition;
        int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length();
        insertStatement.addSQLToken(new InsertValuesToken(beginPosition, insertStatement.getTables().getSingleTableName()));
        do {
            beginPosition = this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length();
            int startParametersIndex = insertStatement.getParametersIndex();
            this.lexerEngine.accept(Symbol.LEFT_PAREN);
            LinkedList<SQLExpression> sqlExpressions = new LinkedList<SQLExpression>();
            int count = 0;
            do {
                sqlExpressions.add(this.basicExpressionParser.parse(insertStatement));
                this.skipsDoubleColon();
                ++count;
            } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
            this.removeGenerateKeyColumn(insertStatement, count);
            count = 0;
            AndCondition andCondition = new AndCondition();
            for (Column each : insertStatement.getColumns()) {
                SQLExpression sqlExpression = (SQLExpression)sqlExpressions.get(count);
                if (this.shardingRule.isShardingColumn(each)) {
                    if (!(sqlExpression instanceof SQLNumberExpression || sqlExpression instanceof SQLTextExpression || sqlExpression instanceof SQLPlaceholderExpression)) {
                        throw new SQLParsingException("INSERT INTO can not support complex expression value on sharding column '%s'.", each.getName());
                    }
                    andCondition.getConditions().add(new Condition(each, sqlExpression));
                }
                if (insertStatement.getGenerateKeyColumnIndex() == count) {
                    insertStatement.getGeneratedKeyConditions().add(this.createGeneratedKeyCondition(each, sqlExpression));
                }
                ++count;
            }
            endPosition = this.lexerEngine.getCurrentToken().getEndPosition();
            this.lexerEngine.accept(Symbol.RIGHT_PAREN);
            InsertValue insertValue = new InsertValue(DefaultKeyword.VALUES, this.lexerEngine.getInput().substring(beginPosition, endPosition), insertStatement.getParametersIndex() - startParametersIndex);
            insertStatement.getInsertValues().getInsertValues().add(insertValue);
            insertStatement.getConditions().getOrCondition().getAndConditions().add(andCondition);
        } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
        insertStatement.setInsertValuesListLastPosition(endPosition);
    }

    private void removeGenerateKeyColumn(InsertStatement insertStatement, int valueCount) {
        Optional<Column> generateKeyColumn = this.shardingRule.getGenerateKeyColumn(insertStatement.getTables().getSingleTableName());
        if (generateKeyColumn.isPresent() && valueCount < insertStatement.getColumns().size()) {
            List<ItemsToken> itemsTokens = insertStatement.getItemsTokens();
            insertStatement.getColumns().remove(new Column(((Column)generateKeyColumn.get()).getName(), insertStatement.getTables().getSingleTableName()));
            for (ItemsToken each : itemsTokens) {
                each.getItems().remove(((Column)generateKeyColumn.get()).getName());
                insertStatement.setGenerateKeyColumnIndex(-1);
            }
        }
    }

    private GeneratedKeyCondition createGeneratedKeyCondition(Column column, SQLExpression sqlExpression) {
        GeneratedKeyCondition result;
        if (sqlExpression instanceof SQLPlaceholderExpression) {
            result = new GeneratedKeyCondition(column, ((SQLPlaceholderExpression)sqlExpression).getIndex(), null);
        } else if (sqlExpression instanceof SQLNumberExpression) {
            result = new GeneratedKeyCondition(column, -1, ((SQLNumberExpression)sqlExpression).getNumber());
        } else {
            throw new ShardingException("Generated key only support number.", new Object[0]);
        }
        return result;
    }

    private void skipsDoubleColon() {
        if (this.lexerEngine.skipIfEqual(Symbol.DOUBLE_COLON)) {
            this.lexerEngine.nextToken();
        }
    }
}

