/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.clause;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.dialect.mysql.MySQLKeyword;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.lexer.token.Keyword;
import io.shardingsphere.core.parsing.lexer.token.Symbol;
import io.shardingsphere.core.parsing.lexer.token.TokenType;
import io.shardingsphere.core.parsing.parser.clause.SQLClauseParser;
import io.shardingsphere.core.parsing.parser.clause.expression.AliasExpressionParser;
import io.shardingsphere.core.parsing.parser.clause.expression.BasicExpressionParser;
import io.shardingsphere.core.parsing.parser.context.table.Table;
import io.shardingsphere.core.parsing.parser.dialect.ExpressionParserFactory;
import io.shardingsphere.core.parsing.parser.exception.SQLParsingUnsupportedException;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.token.IndexToken;
import io.shardingsphere.core.parsing.parser.token.TableToken;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.core.util.SQLUtil;
import java.util.Arrays;
import java.util.LinkedList;

public class TableReferencesClauseParser
implements SQLClauseParser {
    private final ShardingRule shardingRule;
    private final LexerEngine lexerEngine;
    private final AliasExpressionParser aliasExpressionParser;
    private final BasicExpressionParser basicExpressionParser;

    public TableReferencesClauseParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
        this.aliasExpressionParser = ExpressionParserFactory.createAliasExpressionParser(lexerEngine);
        this.basicExpressionParser = ExpressionParserFactory.createBasicExpressionParser(lexerEngine);
    }

    public final void parse(SQLStatement sqlStatement, boolean isSingleTableOnly) {
        do {
            this.parseTableReference(sqlStatement, isSingleTableOnly);
        } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
    }

    protected void parseTableReference(SQLStatement sqlStatement, boolean isSingleTableOnly) {
        this.parseTableFactor(sqlStatement, isSingleTableOnly);
    }

    protected final void parseTableFactor(SQLStatement sqlStatement, boolean isSingleTableOnly) {
        String tableName;
        int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length();
        String literals = this.lexerEngine.getCurrentToken().getLiterals();
        int skippedSchemaNameLength = 0;
        this.lexerEngine.nextToken();
        if (this.lexerEngine.skipIfEqual(Symbol.DOT)) {
            skippedSchemaNameLength = literals.length() + Symbol.DOT.getLiterals().length();
            literals = this.lexerEngine.getCurrentToken().getLiterals();
            this.lexerEngine.nextToken();
        }
        if (Strings.isNullOrEmpty((String)(tableName = SQLUtil.getExactlyValue(literals)))) {
            return;
        }
        if (isSingleTableOnly || this.shardingRule.tryFindTableRuleByLogicTable(tableName).isPresent() || this.shardingRule.findBindingTableRule(tableName).isPresent() || this.shardingRule.getShardingDataSourceNames().getDataSourceNames().contains(this.shardingRule.getShardingDataSourceNames().getDefaultDataSourceName())) {
            sqlStatement.addSQLToken(new TableToken(beginPosition, skippedSchemaNameLength, literals));
            sqlStatement.getTables().add(new Table(tableName, this.aliasExpressionParser.parseTableAlias(sqlStatement, true, tableName)));
        } else {
            this.aliasExpressionParser.parseTableAlias();
        }
        this.parseForceIndex(tableName, sqlStatement);
        this.parseJoinTable(sqlStatement);
        if (isSingleTableOnly && !sqlStatement.getTables().isSingleTable()) {
            throw new SQLParsingUnsupportedException("Cannot support Multiple-Table.");
        }
    }

    private void parseForceIndex(String tableName, SQLStatement sqlStatement) {
        boolean skipIfForce;
        boolean bl = skipIfForce = this.lexerEngine.skipIfEqual(MySQLKeyword.FORCE) && this.lexerEngine.skipIfEqual(DefaultKeyword.INDEX);
        if (skipIfForce) {
            this.lexerEngine.accept(Symbol.LEFT_PAREN);
            do {
                this.lexerEngine.skipIfEqual(Symbol.COMMA);
                String literals = this.lexerEngine.getCurrentToken().getLiterals();
                Preconditions.checkState((!Symbol.RIGHT_PAREN.getLiterals().equals(literals) ? 1 : 0) != 0, (Object)"There is an error in the vicinity of the force index syntax.");
                if (this.shardingRule.isLogicIndex(literals, tableName)) {
                    int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition() - literals.length();
                    sqlStatement.addSQLToken(new IndexToken(beginPosition, literals, tableName));
                }
                this.lexerEngine.nextToken();
            } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
            this.lexerEngine.accept(Symbol.RIGHT_PAREN);
        }
    }

    private void parseJoinTable(SQLStatement sqlStatement) {
        while (this.parseJoinType()) {
            if (this.lexerEngine.equalAny(Symbol.LEFT_PAREN)) {
                throw new SQLParsingUnsupportedException("Cannot support sub query for join table.");
            }
            this.parseTableFactor(sqlStatement, false);
            this.parseJoinCondition(sqlStatement);
        }
    }

    private boolean parseJoinType() {
        LinkedList<Keyword> joinTypeKeywords = new LinkedList<Keyword>();
        joinTypeKeywords.addAll(Arrays.asList(DefaultKeyword.INNER, DefaultKeyword.OUTER, DefaultKeyword.LEFT, DefaultKeyword.RIGHT, DefaultKeyword.FULL, DefaultKeyword.CROSS, DefaultKeyword.NATURAL, DefaultKeyword.JOIN));
        joinTypeKeywords.addAll(Arrays.asList(this.getKeywordsForJoinType()));
        TokenType[] joinTypeKeywordArrays = joinTypeKeywords.toArray(new Keyword[joinTypeKeywords.size()]);
        if (!this.lexerEngine.equalAny(joinTypeKeywordArrays)) {
            return false;
        }
        this.lexerEngine.skipAll(joinTypeKeywordArrays);
        return true;
    }

    protected Keyword[] getKeywordsForJoinType() {
        return new Keyword[0];
    }

    private void parseJoinCondition(SQLStatement sqlStatement) {
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.ON)) {
            do {
                this.basicExpressionParser.parse(sqlStatement);
                this.lexerEngine.accept(Symbol.EQ);
                this.basicExpressionParser.parse(sqlStatement);
            } while (this.lexerEngine.skipIfEqual(DefaultKeyword.AND));
        } else if (this.lexerEngine.skipIfEqual(DefaultKeyword.USING)) {
            this.lexerEngine.skipParentheses(sqlStatement);
        }
    }

    public final void parseSingleTableWithoutAlias(SQLStatement sqlStatement) {
        int beginPosition = this.lexerEngine.getCurrentToken().getEndPosition() - this.lexerEngine.getCurrentToken().getLiterals().length();
        String literals = this.lexerEngine.getCurrentToken().getLiterals();
        int skippedSchemaNameLength = 0;
        this.lexerEngine.nextToken();
        if (this.lexerEngine.skipIfEqual(Symbol.DOT)) {
            skippedSchemaNameLength = literals.length() + Symbol.DOT.getLiterals().length();
            literals = this.lexerEngine.getCurrentToken().getLiterals();
            this.lexerEngine.nextToken();
        }
        sqlStatement.addSQLToken(new TableToken(beginPosition, skippedSchemaNameLength, literals));
        sqlStatement.getTables().add(new Table(SQLUtil.getExactlyValue(literals), (Optional<String>)Optional.absent()));
    }

    public LexerEngine getLexerEngine() {
        return this.lexerEngine;
    }
}

