/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.sql.ddl.create.table;

import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.lexer.token.Keyword;
import io.shardingsphere.core.parsing.lexer.token.Symbol;
import io.shardingsphere.core.parsing.parser.clause.TableReferencesClauseParser;
import io.shardingsphere.core.parsing.parser.exception.SQLParsingException;
import io.shardingsphere.core.parsing.parser.sql.SQLParser;
import io.shardingsphere.core.parsing.parser.sql.ddl.DDLStatement;
import io.shardingsphere.core.parsing.parser.sql.ddl.create.table.CreateTableStatement;
import io.shardingsphere.core.rule.ShardingRule;
import java.util.LinkedList;

public abstract class AbstractCreateTableParser
implements SQLParser {
    private final ShardingRule shardingRule;
    private final LexerEngine lexerEngine;
    private final TableReferencesClauseParser tableReferencesClauseParser;

    public AbstractCreateTableParser(ShardingRule shardingRule, LexerEngine lexerEngine) {
        this.shardingRule = shardingRule;
        this.lexerEngine = lexerEngine;
        this.tableReferencesClauseParser = new TableReferencesClauseParser(shardingRule, lexerEngine);
    }

    @Override
    public final DDLStatement parse() {
        this.lexerEngine.skipAll(this.getSkippedKeywordsBetweenCreateIndexAndKeyword());
        this.lexerEngine.skipAll(this.getSkippedKeywordsBetweenCreateAndKeyword());
        CreateTableStatement result = new CreateTableStatement();
        if (!this.lexerEngine.skipIfEqual(DefaultKeyword.TABLE)) {
            throw new SQLParsingException("Can't support other CREATE grammar unless CREATE TABLE.", new Object[0]);
        }
        this.lexerEngine.skipAll(this.getSkippedKeywordsBetweenCreateTableAndTableName());
        this.tableReferencesClauseParser.parseSingleTableWithoutAlias(result);
        this.lexerEngine.accept(Symbol.LEFT_PAREN);
        do {
            this.parseCreateDefinition(result);
        } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
        this.lexerEngine.accept(Symbol.RIGHT_PAREN);
        return result;
    }

    protected abstract Keyword[] getSkippedKeywordsBetweenCreateIndexAndKeyword();

    protected abstract Keyword[] getSkippedKeywordsBetweenCreateAndKeyword();

    protected abstract Keyword[] getSkippedKeywordsBetweenCreateTableAndTableName();

    private void parseCreateDefinition(CreateTableStatement statement) {
        String columnName = this.parseColumnName(statement);
        this.parseColumnDefinition(columnName, statement);
    }

    private String parseColumnName(CreateTableStatement statement) {
        String result = this.lexerEngine.getCurrentToken().getLiterals();
        statement.getColumnNames().add(result);
        return result;
    }

    private void parseColumnDefinition(String columnName, CreateTableStatement statement) {
        this.parseDataType(statement);
        this.lexerEngine.skipUntil(DefaultKeyword.PRIMARY, Symbol.COMMA, Symbol.RIGHT_PAREN);
        if (this.lexerEngine.skipIfEqual(DefaultKeyword.PRIMARY)) {
            this.lexerEngine.accept(DefaultKeyword.KEY);
            this.lexerEngine.skipAll(this.getSkippedKeywordsBeforeTableConstraint());
            if (this.lexerEngine.skipIfEqual(Symbol.LEFT_PAREN)) {
                this.parseTableConstraint(statement);
            } else {
                this.parseInlineConstraint(columnName, statement);
            }
        }
    }

    private void parseDataType(CreateTableStatement statement) {
        this.lexerEngine.nextToken();
        statement.getColumnTypes().add(this.lexerEngine.getCurrentToken().getLiterals());
        this.lexerEngine.skipParentheses(statement);
    }

    protected abstract Keyword[] getSkippedKeywordsBeforeTableConstraint();

    private void parseTableConstraint(CreateTableStatement statement) {
        LinkedList<String> columnNames = new LinkedList<String>();
        do {
            columnNames.add(this.lexerEngine.getCurrentToken().getLiterals());
            this.lexerEngine.nextToken();
            this.lexerEngine.skipParentheses(statement);
            this.lexerEngine.skipUntil(Symbol.COMMA, Symbol.RIGHT_PAREN);
        } while (this.lexerEngine.skipIfEqual(Symbol.COMMA));
        statement.getPrimaryKeyColumns().addAll(columnNames);
    }

    private void parseInlineConstraint(String columnName, CreateTableStatement statement) {
        statement.getPrimaryKeyColumns().add(columnName);
        this.lexerEngine.skipUntil(Symbol.COMMA, Symbol.RIGHT_PAREN);
    }

    protected ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    protected LexerEngine getLexerEngine() {
        return this.lexerEngine;
    }

    protected TableReferencesClauseParser getTableReferencesClauseParser() {
        return this.tableReferencesClauseParser;
    }
}

