/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.sql.ddl.create.table;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.parsing.lexer.LexerEngine;
import io.shardingsphere.core.parsing.parser.dialect.mysql.sql.MySQLCreateTableParser;
import io.shardingsphere.core.parsing.parser.dialect.oracle.sql.OracleCreateTableParser;
import io.shardingsphere.core.parsing.parser.dialect.postgresql.sql.PostgreSQLCreateTableParser;
import io.shardingsphere.core.parsing.parser.dialect.sqlserver.sql.SQLServerCreateTableParser;
import io.shardingsphere.core.parsing.parser.sql.ddl.create.table.AbstractCreateTableParser;
import io.shardingsphere.core.rule.ShardingRule;

public final class CreateTableParserFactory {
    public static AbstractCreateTableParser newInstance(DatabaseType dbType, ShardingRule shardingRule, LexerEngine lexerEngine) {
        switch (dbType) {
            case H2: 
            case MySQL: {
                return new MySQLCreateTableParser(shardingRule, lexerEngine);
            }
            case Oracle: {
                return new OracleCreateTableParser(shardingRule, lexerEngine);
            }
            case SQLServer: {
                return new SQLServerCreateTableParser(shardingRule, lexerEngine);
            }
            case PostgreSQL: {
                return new PostgreSQLCreateTableParser(shardingRule, lexerEngine);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot support database [%s].", new Object[]{dbType}));
    }

    private CreateTableParserFactory() {
    }
}

