/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.routing.type.broadcast;

import io.shardingsphere.core.metadata.datasource.ShardingDataSourceMetaData;
import io.shardingsphere.core.routing.type.RoutingEngine;
import io.shardingsphere.core.routing.type.RoutingResult;
import io.shardingsphere.core.routing.type.TableUnit;
import io.shardingsphere.core.rule.ShardingRule;
import java.beans.ConstructorProperties;

public final class InstanceBroadcastRoutingEngine
implements RoutingEngine {
    private final ShardingRule shardingRule;
    private final ShardingDataSourceMetaData shardingDataSourceMetaData;

    @Override
    public RoutingResult route() {
        RoutingResult result = new RoutingResult();
        for (String each : this.shardingRule.getShardingDataSourceNames().getDataSourceNames()) {
            if (!this.shardingDataSourceMetaData.getAllInstanceDataSourceNames().contains(each)) continue;
            result.getTableUnits().getTableUnits().add(new TableUnit(each));
        }
        return result;
    }

    @ConstructorProperties(value={"shardingRule", "shardingDataSourceMetaData"})
    public InstanceBroadcastRoutingEngine(ShardingRule shardingRule, ShardingDataSourceMetaData shardingDataSourceMetaData) {
        this.shardingRule = shardingRule;
        this.shardingDataSourceMetaData = shardingDataSourceMetaData;
    }
}

