/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.internal;

import io.smallrye.faulttolerance.SpecCompatibility;
import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.metrics.MetricsRecorder;
import io.smallrye.faulttolerance.internal.FallbackMethodCandidates;
import io.smallrye.faulttolerance.internal.InterceptionPoint;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class StrategyCache {
    private final Map<InterceptionPoint, FaultToleranceStrategy<?>> strategies = new ConcurrentHashMap();
    private final Map<InterceptionPoint, MetricsRecorder> metricsRecorders = new ConcurrentHashMap<InterceptionPoint, MetricsRecorder>();
    private final Map<InterceptionPoint, FallbackMethodCandidates> fallbackMethods = new ConcurrentHashMap<InterceptionPoint, FallbackMethodCandidates>();
    private final SpecCompatibility specCompatibility;

    @Inject
    public StrategyCache(SpecCompatibility specCompatibility) {
        this.specCompatibility = specCompatibility;
    }

    public <V> FaultToleranceStrategy<V> getStrategy(InterceptionPoint point, Supplier<FaultToleranceStrategy<V>> producer) {
        return this.strategies.computeIfAbsent(point, ignored -> (FaultToleranceStrategy)producer.get());
    }

    public MetricsRecorder getMetrics(InterceptionPoint point, Supplier<MetricsRecorder> producer) {
        return this.metricsRecorders.computeIfAbsent(point, ignored -> (MetricsRecorder)producer.get());
    }

    public FallbackMethodCandidates getFallbackMethodCandidates(InterceptionPoint point, String fallbackMethodName) {
        return this.fallbackMethods.computeIfAbsent(point, ignored -> FallbackMethodCandidates.create(point, fallbackMethodName, this.specCompatibility.allowFallbackMethodExceptionParameter()));
    }
}

