/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.build;

import io.smallrye.jwt.build.JwtClaimsBuilder;
import io.smallrye.jwt.build.spi.JwtProvider;
import jakarta.json.JsonObject;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;

public final class Jwt {
    public static JwtClaimsBuilder claims() {
        return JwtProvider.provider().claims();
    }

    public static JwtClaimsBuilder claims(Map<String, Object> claims) {
        return JwtProvider.provider().claims(claims);
    }

    public static JwtClaimsBuilder claims(JsonObject jsonObject) {
        return JwtProvider.provider().claims(jsonObject);
    }

    public static JwtClaimsBuilder claims(String jsonLocation) {
        return JwtProvider.provider().claims(jsonLocation);
    }

    public static JwtClaimsBuilder claims(JsonWebToken jwt) {
        return JwtProvider.provider().claims(jwt);
    }

    public static JwtClaimsBuilder claim(Claims name, Object value) {
        return Jwt.claims().claim(name, value);
    }

    public static JwtClaimsBuilder claim(String name, Object value) {
        return Jwt.claims().claim(name, value);
    }

    public static JwtClaimsBuilder issuer(String issuer) {
        return Jwt.claims().issuer(issuer);
    }

    public static JwtClaimsBuilder subject(String subject) {
        return Jwt.claims().subject(subject);
    }

    public static JwtClaimsBuilder groups(String groups) {
        return Jwt.claims().groups(groups);
    }

    public static JwtClaimsBuilder groups(Set<String> groups) {
        return Jwt.claims().groups(groups);
    }

    public static JwtClaimsBuilder scope(String scope) {
        return Jwt.claims().scope(scope);
    }

    public static JwtClaimsBuilder scope(Set<String> scopes) {
        return Jwt.claims().scope(scopes);
    }

    public static JwtClaimsBuilder audience(String audience) {
        return Jwt.claims().audience(audience);
    }

    public static JwtClaimsBuilder audience(Set<String> audiences) {
        return Jwt.claims().audience(audiences);
    }

    public static JwtClaimsBuilder upn(String upn) {
        return Jwt.claims().upn(upn);
    }

    public static JwtClaimsBuilder preferredUserName(String preferredUserName) {
        return Jwt.claims().preferredUserName(preferredUserName);
    }

    public static String sign(String jsonLocation) {
        return Jwt.claims(jsonLocation).sign();
    }

    public static String sign(Map<String, Object> claims) {
        return Jwt.claims(claims).sign();
    }

    public static String sign(JsonObject jsonObject) {
        return Jwt.claims(jsonObject).sign();
    }

    public static String encrypt(String jsonLocation) {
        return Jwt.claims(jsonLocation).jwe().encrypt();
    }

    public static String encrypt(Map<String, Object> claims) {
        return Jwt.claims(claims).jwe().encrypt();
    }

    public static String encrypt(JsonObject jsonObject) {
        return Jwt.claims(jsonObject).jwe().encrypt();
    }

    public static String innerSignAndEncrypt(String jsonLocation) {
        return Jwt.claims(jsonLocation).innerSign().encrypt();
    }

    public static String innerSignAndEncrypt(Map<String, Object> claims) {
        return Jwt.claims(claims).innerSign().encrypt();
    }

    public static String innerSignAndEncrypt(JsonObject jsonObject) {
        return Jwt.claims(jsonObject).innerSign().encrypt();
    }
}

