/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.impl.RouteImpl;
import io.vertx.ext.web.impl.RouteState;
import io.vertx.ext.web.impl.RouterImpl;
import io.vertx.ext.web.impl.RoutingContextInternal;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class RoutingContextImplBase
implements RoutingContextInternal {
    protected static final Logger LOG = LoggerFactory.getLogger(RoutingContext.class);
    private final Set<RouteImpl> routes;
    protected final String mountPoint;
    private final AtomicInteger currentRouteNextHandlerIndex;
    private final AtomicInteger currentRouteNextFailureHandlerIndex;
    protected Iterator<RouteImpl> iter;
    protected RouteState currentRoute;
    int matchFailure;
    int matchRest = -1;
    boolean matchNormalized;
    private volatile long seen;

    RoutingContextImplBase(String mountPoint, Set<RouteImpl> routes) {
        this.mountPoint = mountPoint;
        this.routes = routes;
        this.iter = routes.iterator();
        this.currentRouteNextHandlerIndex = new AtomicInteger(0);
        this.currentRouteNextFailureHandlerIndex = new AtomicInteger(0);
        this.resetMatchFailure();
    }

    @Override
    public synchronized RoutingContextInternal visitHandler(int id) {
        this.seen |= (long)id;
        return this;
    }

    @Override
    public boolean seenHandler(int id) {
        return (this.seen & (long)id) != 0L;
    }

    @Override
    public synchronized RoutingContextInternal setMatchFailure(int matchFailure) {
        this.matchFailure = matchFailure;
        return this;
    }

    @Override
    public String mountPoint() {
        return this.mountPoint;
    }

    @Override
    public Route currentRoute() {
        if (this.currentRoute == null) {
            return null;
        }
        return this.currentRoute.getRoute();
    }

    int currentRouteNextHandlerIndex() {
        return this.currentRouteNextHandlerIndex.intValue();
    }

    int currentRouteNextFailureHandlerIndex() {
        return this.currentRouteNextFailureHandlerIndex.intValue();
    }

    void restart() {
        this.iter = this.routes.iterator();
        this.currentRoute = null;
        this.next();
    }

    boolean iterateNext() {
        boolean failed = this.failed();
        if (this.currentRoute != null) {
            try {
                if (!failed && this.currentRoute.hasNextContextHandler(this)) {
                    this.currentRouteNextHandlerIndex.incrementAndGet();
                    this.resetMatchFailure();
                    this.currentRoute.handleContext(this);
                    return true;
                }
                if (failed && this.currentRoute.hasNextFailureHandler(this)) {
                    this.currentRouteNextFailureHandlerIndex.incrementAndGet();
                    this.currentRoute.handleFailure(this);
                    return true;
                }
            }
            catch (Throwable t) {
                this.handleInHandlerRuntimeFailure(this.currentRoute.getRouter(), failed, t);
                return true;
            }
        }
        while (this.iter.hasNext()) {
            RouteState routeState = this.iter.next().state();
            this.currentRouteNextHandlerIndex.set(0);
            this.currentRouteNextFailureHandlerIndex.set(0);
            try {
                int matchResult = routeState.matches(this, this.mountPoint(), failed);
                if (matchResult == 0) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Route matches: " + routeState));
                    }
                    this.resetMatchFailure();
                    try {
                        this.currentRoute = routeState;
                        this.request().routed(this.currentRoute.getName());
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("Calling the " + (failed ? "failure" : "") + " handler"));
                        }
                        if (failed && this.currentRoute.hasNextFailureHandler(this)) {
                            this.currentRouteNextFailureHandlerIndex.incrementAndGet();
                            routeState.handleFailure(this);
                        } else {
                            if (!this.currentRoute.hasNextContextHandler(this)) continue;
                            this.currentRouteNextHandlerIndex.incrementAndGet();
                            routeState.handleContext(this);
                        }
                    }
                    catch (Throwable t) {
                        this.handleInHandlerRuntimeFailure(routeState.getRouter(), failed, t);
                    }
                    return true;
                }
                if (matchResult == 405) {
                    if (this.matchFailure != 404) continue;
                    this.matchFailure = matchResult;
                    continue;
                }
                if (matchResult == 404) continue;
                this.matchFailure = matchResult;
            }
            catch (Throwable e) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)"IllegalArgumentException thrown during iteration", e);
                }
                if (!this.response().ended()) {
                    this.unhandledFailure(e instanceof IllegalArgumentException ? 400 : -1, e, routeState.getRouter());
                }
                return true;
            }
        }
        return false;
    }

    private void handleInHandlerRuntimeFailure(RouterImpl router, boolean failed, Throwable t) {
        LOG.error((Object)"Unhandled exception in router", t);
        if (!failed) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Failing the routing");
            }
            this.fail(t);
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Failure in handling failure");
            }
            this.unhandledFailure(-1, t, router);
        }
    }

    protected void unhandledFailure(int statusCode, Throwable failure, RouterImpl router) {
        int code = statusCode != -1 ? statusCode : (failure instanceof HttpException ? ((HttpException)failure).getStatusCode() : 500);
        Handler<RoutingContext> errorHandler = router.getErrorHandlerByStatusCode(code);
        if (errorHandler != null) {
            try {
                errorHandler.handle((Object)this);
            }
            catch (Throwable t) {
                LOG.error((Object)"Error in error handler", t);
            }
        }
        if (!this.response().ended() && !this.response().closed()) {
            try {
                this.response().setStatusCode(code);
            }
            catch (IllegalArgumentException e) {
                this.response().setStatusMessage(HttpResponseStatus.valueOf((int)code).reasonPhrase()).setStatusCode(code);
            }
            this.response().end(this.response().getStatusMessage());
        }
    }

    private void resetMatchFailure() {
        this.matchFailure = 404;
    }
}

