/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.core;

import java.io.File;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.tecgraf.jtdk.core.swig.TdkCacheInitParams;
import org.tecgraf.jtdk.core.swig.TdkCacheManager;
import org.tecgraf.jtdk.core.swig.TdkDefaultPersistenceInitializer;
import org.tecgraf.jtdk.core.swig.TdkJavaGraphicalInitializer;
import org.tecgraf.jtdk.core.swig.TdkLoggerManager;
import org.tecgraf.jtdk.core.swig.TdkSetup;
import org.tecgraf.jtdk.core.swig.coreJNI;

public class TdkDefaultInitializer {
    public static final String LOG_TRACE = "TRACE";
    public static final String LOG_DEBUG = Level.DEBUG.toString();
    public static final String LOG_INFO = Level.INFO.toString();
    public static final String LOG_WARN = Level.WARN.toString();
    public static final String LOG_ERROR = Level.ERROR.toString();
    public static final String LOG_FATAL = Level.FATAL.toString();
    public static final String LOG_OFF = Level.OFF.toString();
    private static final int DEFAULT_CACHE_MEM_SIZE = 1024;
    private static final int DEFAULT_CACHE_DISK_SIZE = 64;

    public void initializeTdk() {
        this.initializeTdkCacheParams(1024, 64);
    }

    public void initializeTdkLogParams(String string) {
        this.initializeTdkLogCacheParams(string, 1024, 64);
    }

    public void initializeTdkLogParams(File file) {
        this.initializeTdkLogCacheParams(file, 1024, 64);
    }

    public void initializeTdkCacheParams(int n, int n2) {
        coreJNI.init();
        this.initLogger(LOG_OFF);
        this.initTdkServices(n, n2);
    }

    public void initializeTdkLogCacheParams(String string, int n, int n2) {
        coreJNI.init();
        this.initLogger(string);
        this.initTdkServices(n, n2);
    }

    public void initializeTdkLogCacheParams(File file, int n, int n2) {
        coreJNI.init();
        this.initLogger(file);
        this.initTdkServices(n, n2);
    }

    private void initTdkServices(int n, int n2) {
        this.initPersistenceService();
        this.initGraphicalService();
        this.initRenderingCache(n, n2);
    }

    private void initPersistenceService() {
        TdkDefaultPersistenceInitializer tdkDefaultPersistenceInitializer = new TdkDefaultPersistenceInitializer();
        TdkSetup.initializePersistence(tdkDefaultPersistenceInitializer);
    }

    protected void initGraphicalService() {
        TdkJavaGraphicalInitializer tdkJavaGraphicalInitializer = new TdkJavaGraphicalInitializer();
        TdkSetup.initializeGraphics(tdkJavaGraphicalInitializer);
    }

    protected void initRenderingCache(int n, int n2) {
        TdkCacheInitParams tdkCacheInitParams = new TdkCacheInitParams();
        tdkCacheInitParams.setDefaultParamsTerralib();
        tdkCacheInitParams.setMaxBlocksInMemory(n);
        tdkCacheInitParams.setDiskCacheSize(n2);
        TdkCacheManager.init(tdkCacheInitParams);
    }

    private void initLogger(String string) {
        BasicConfigurator.configure();
        if (string.equals(LOG_TRACE)) {
            Logger.getLogger((String)"org.tecgraf.jvipe").setLevel(Level.DEBUG);
        } else {
            Logger.getLogger((String)"org.tecgraf.jvipe").setLevel(Level.toLevel((String)string));
        }
        TdkLoggerManager.initialize(string);
    }

    private void initLogger(File file) {
        String string = file.toString();
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        if (string2.equalsIgnoreCase("xml")) {
            DOMConfigurator.configure((String)string);
            TdkLoggerManager.initializeFromXml(string);
        } else {
            PropertyConfigurator.configure((String)string);
            TdkLoggerManager.initializeFromProperties(string);
        }
    }
}

