/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.core;

import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.TdkCoreI18n;
import org.tecgraf.jtdk.core.TdkFeedbackListener;
import org.tecgraf.jtdk.core.TdkFeedbackTask;

public class TdkFeedback {
    private static Logger _logger = Logger.getLogger(TdkFeedback.class);
    Hashtable<String, Integer> _intMap = new Hashtable();
    Hashtable<String, Float> _floatMap = new Hashtable();
    Hashtable<String, String> _stringMap = new Hashtable();
    Hashtable<String, Boolean> _booleanMap = new Hashtable();
    Vector<TdkFeedbackListener> _listeners = new Vector();
    Stack<TdkFeedbackTask> _tasks = new Stack();
    private float _currentProgressRate = 0.0f;
    private String _currentDescription;
    Stack<Float> _progressRelevanceStack = new Stack();

    public void reset() {
        this._intMap.clear();
        this._floatMap.clear();
        this._stringMap.clear();
        this._booleanMap.clear();
        this._listeners.clear();
        this._tasks.clear();
        this._progressRelevanceStack.clear();
        this._currentDescription = null;
        this._currentProgressRate = 0.0f;
    }

    public int getIntProperty(String string) {
        Integer n = this._intMap.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public float getFloatProperty(String string) {
        Float f = this._floatMap.get(string);
        if (f == null) {
            return -1.0f;
        }
        return f.floatValue();
    }

    public String getStringProperty(String string) {
        return this._stringMap.get(string);
    }

    public boolean getBooleanProperty(String string) {
        Boolean bl = this._booleanMap.get(string);
        return bl;
    }

    public void setIntProperty(String string, int n) {
        if (string != null && string.length() > 0) {
            this._intMap.put(string, new Integer(n));
            this.fireFeedbackChange();
        }
    }

    public void setFloatProperty(String string, float f) {
        if (string != null && string.length() > 0) {
            this._floatMap.put(string, new Float(f));
            this.fireFeedbackChange();
        }
    }

    public void setStringProperty(String string, String string2) {
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
            this._stringMap.put(string, string2);
            this.fireFeedbackChange();
        }
    }

    public void setBooleanProperty(String string, boolean bl) {
        if (string != null && string.length() > 0) {
            this._booleanMap.put(string, new Boolean(bl));
            this.fireFeedbackChange();
        }
    }

    public void addFeedbackListener(TdkFeedbackListener tdkFeedbackListener) {
        this._listeners.add(tdkFeedbackListener);
    }

    public void removeFeedbackListener(TdkFeedbackListener tdkFeedbackListener) {
        this._listeners.remove(tdkFeedbackListener);
    }

    protected void fireFeedbackChange() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).feedbackEvent(this);
        }
    }

    public void beginTask(String string, String string2, float f) {
        if (f < 0.0f || f > 100.0f) {
            throw new IllegalArgumentException("progressRelevance must be [0-100]. Actual : " + f);
        }
        float f2 = f / 100.0f;
        if (!this._tasks.empty()) {
            f2 *= this._tasks.peek().getProgressRelevance();
        }
        TdkFeedbackTask tdkFeedbackTask = new TdkFeedbackTask(string, f2);
        this._tasks.push(tdkFeedbackTask);
        this._progressRelevanceStack.push(Float.valueOf(this._currentProgressRate));
        if (string2 != null && string2.length() != 0) {
            this._currentDescription = string2;
            tdkFeedbackTask.setResetDescriptionOnEnd(true);
        }
        this.fireFeedbackChange();
    }

    private void beginTaskTranslate(String string, String string2, float f) {
        String string3 = null;
        if (string2 != null || string2 != "") {
            string3 = TdkCoreI18n.getString(string2);
        }
        this.beginTask(string, string3, f);
    }

    public void endTask() {
        TdkFeedbackTask tdkFeedbackTask = this._tasks.pop();
        this._currentProgressRate = this._progressRelevanceStack.pop().floatValue();
        this._currentProgressRate += tdkFeedbackTask.getProgressRelevance();
        if (tdkFeedbackTask.isToResetDescriptionOnEnd()) {
            this._currentDescription = null;
        }
        this.fireFeedbackChange();
    }

    public String getCurrentTaskName() {
        if (this._tasks.isEmpty()) {
            return null;
        }
        String string = this._tasks.peek().getName();
        return string;
    }

    public String getCurrentTaskDescription() {
        return this._currentDescription;
    }

    public int getCurrentProgressRate() {
        return Math.round(this._currentProgressRate * 100.0f);
    }
}

