/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.core.algorithms;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.TdkJavaProcessingService;
import org.tecgraf.jtdk.core.algorithms.TdkCalcOrthodromicDistance;
import org.tecgraf.jtdk.core.exceptions.TdkInvalidParamValueException;
import org.tecgraf.jtdk.core.swig.TeDatum;
import org.tecgraf.jtdk.core.swig.TeProjection;
import org.tecgraf.jtdk.core.swig.TeProjectionFactory;
import org.tecgraf.jtdk.core.swig.TeProjectionParams;

public class TdkGeneratePolygonByRadius {
    private static Logger _logger = Logger.getLogger(TdkGeneratePolygonByRadius.class);
    private static final TdkJavaProcessingService _processingService = new TdkJavaProcessingService();
    private static final GeometryFactory _geometryFactory = new GeometryFactory();
    private static TeProjection _wgs84;
    private static Envelope _worldBox;
    private static LineSegment[] _worldBoxSegments;
    private static TdkJavaProcessingService _service;

    public static synchronized Polygon create(Coordinate coordinate, Coordinate coordinate2, TeProjection teProjection, int n, double d) throws TdkInvalidParamValueException {
        double d2;
        if (coordinate == null || coordinate2 == null || teProjection == null) {
            String string = new String("Invalid param: null");
            _logger.error((Object)string);
            throw new TdkInvalidParamValueException(string);
        }
        Coordinate coordinate3 = _service.convertCoord(coordinate, teProjection, _wgs84);
        Coordinate coordinate4 = _service.convertCoord(coordinate2, teProjection, _wgs84);
        if (!_worldBox.contains(coordinate3) || !_worldBox.contains(coordinate4)) {
            String string = new String("Invalid param: a coordinate is out of bounds: WGS84: " + coordinate3 + ";" + coordinate4);
            _logger.error((Object)string);
            throw new TdkInvalidParamValueException(string);
        }
        try {
            d2 = TdkCalcOrthodromicDistance.calcDistanceInMeters(coordinate3, coordinate4);
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage());
            return null;
        }
        return TdkGeneratePolygonByRadius.create(coordinate, teProjection, d2, n, d);
    }

    public static synchronized Polygon create(Coordinate coordinate, TeProjection teProjection, double d, int n, double d2) throws TdkInvalidParamValueException {
        if (coordinate == null || teProjection == null) {
            String string = new String("Invalid param: null");
            _logger.error((Object)string);
            throw new TdkInvalidParamValueException(string);
        }
        if (d2 <= 0.0) {
            String string = new String("Invalid param: precisionInMeters: " + d2);
            _logger.error((Object)string);
            throw new TdkInvalidParamValueException(string);
        }
        if (n < 4) {
            String string = new String("Invalid param: too few vertices: " + n);
            _logger.error((Object)string);
            throw new TdkInvalidParamValueException(string);
        }
        if (d < 0.0) {
            String string = new String("Invalid param: radius < 0");
            _logger.error((Object)string);
            throw new TdkInvalidParamValueException(string);
        }
        if (d == 0.0) {
            return null;
        }
        Coordinate coordinate2 = _service.convertCoord(coordinate, teProjection, _wgs84);
        if (!_worldBox.contains(coordinate2)) {
            String string = new String("Invalid param: center coordinate out of bounds: WGS84:" + coordinate2);
            _logger.error((Object)string);
            throw new TdkInvalidParamValueException(string);
        }
        double d3 = 6.2831853;
        Coordinate[] coordinateArray = new Coordinate[n + 1];
        for (int i = 0; i < n; ++i) {
            double d4 = (double)i * d3 / (double)n;
            Coordinate coordinate3 = TdkGeneratePolygonByRadius.calcCoordFromPoint(coordinate2, d, d4, d2);
            if (coordinate3 == null) {
                return null;
            }
            coordinateArray[i] = _service.convertCoord(coordinate3, _wgs84, teProjection);
        }
        coordinateArray[n] = new Coordinate(coordinateArray[0]);
        LinearRing linearRing = _geometryFactory.createLinearRing(coordinateArray);
        return _geometryFactory.createPolygon(linearRing, null);
    }

    private static Coordinate calcCoordFromPoint(Coordinate coordinate, double d, double d2, double d3) {
        double d4;
        Coordinate coordinate2 = new Coordinate();
        Coordinate coordinate3 = new Coordinate();
        double d5 = Math.sin(d2);
        double d6 = Math.cos(d2);
        double d7 = 540.0;
        coordinate2.x = coordinate.x + d7 * d6;
        coordinate2.y = coordinate.y + d7 * d5;
        coordinate3 = TdkGeneratePolygonByRadius.intersectsWorldBox(coordinate, coordinate2);
        if (coordinate3 == null) {
            _logger.error((Object)"worldBoundCoordinate == null");
            return null;
        }
        try {
            d4 = TdkCalcOrthodromicDistance.calcDistanceInMeters(coordinate, coordinate3);
        }
        catch (Exception exception) {
            return coordinate3;
        }
        double d8 = d4 - d;
        if (d8 < 0.0) {
            return null;
        }
        coordinate2.setCoordinate(coordinate3);
        int n = 0;
        while (Math.abs(d8) > d3) {
            double d9 = coordinate2.x - coordinate.x;
            double d10 = coordinate2.y - coordinate.y;
            if (d4 == 0.0) {
                return coordinate2;
            }
            coordinate2.x -= d9 * d8 / d4;
            coordinate2.y -= d10 * d8 / d4;
            if (!_worldBox.contains(coordinate2)) {
                return null;
            }
            if (n++ > 100) {
                _logger.warn((Object)"Numerical method failed to converge");
                return coordinate3;
            }
            try {
                d4 = TdkCalcOrthodromicDistance.calcDistanceInMeters(coordinate, coordinate2);
            }
            catch (Exception exception) {
                _logger.error((Object)exception.getMessage());
                return coordinate3;
            }
            d8 = d4 - d;
        }
        return coordinate2;
    }

    private static Coordinate intersectsWorldBox(Coordinate coordinate, Coordinate coordinate2) {
        LineSegment lineSegment;
        LineSegment lineSegment2 = new LineSegment(coordinate, coordinate2);
        Coordinate coordinate3 = null;
        LineSegment[] lineSegmentArray = _worldBoxSegments;
        int n = lineSegmentArray.length;
        for (int i = 0; i < n && (coordinate3 = (lineSegment = lineSegmentArray[i]).intersection(lineSegment2)) == null; ++i) {
        }
        return coordinate3;
    }

    static {
        TeProjectionParams teProjectionParams = new TeProjectionParams();
        teProjectionParams.setName("LatLong");
        teProjectionParams.setDatum(new TeDatum("WGS84"));
        _wgs84 = TeProjectionFactory.make(teProjectionParams);
        _worldBox = new Envelope(-180.0, 180.0, -90.0, 90.0);
        _worldBoxSegments = new LineSegment[4];
        TdkGeneratePolygonByRadius._worldBoxSegments[0] = new LineSegment(new Coordinate(_worldBox.getMinX(), _worldBox.getMaxY()), new Coordinate(_worldBox.getMaxX(), _worldBox.getMaxY()));
        TdkGeneratePolygonByRadius._worldBoxSegments[1] = new LineSegment(new Coordinate(_worldBox.getMinX(), _worldBox.getMinY()), new Coordinate(_worldBox.getMaxX(), _worldBox.getMinY()));
        TdkGeneratePolygonByRadius._worldBoxSegments[2] = new LineSegment(new Coordinate(_worldBox.getMinX(), _worldBox.getMinY()), new Coordinate(_worldBox.getMinX(), _worldBox.getMaxY()));
        TdkGeneratePolygonByRadius._worldBoxSegments[3] = new LineSegment(new Coordinate(_worldBox.getMaxX(), _worldBox.getMinY()), new Coordinate(_worldBox.getMaxX(), _worldBox.getMaxY()));
        _service = new TdkJavaProcessingService();
    }
}

