/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.core.data;

import java.awt.Color;
import java.util.Vector;
import org.tecgraf.jtdk.core.data.TdkColorModel;

public class TdkRealInterpolationColorModel
extends TdkColorModel {
    protected Vector<Double> _stripes = new Vector();
    protected Vector<Color> _colors = new Vector();

    public TdkRealInterpolationColorModel() {
    }

    public TdkRealInterpolationColorModel(double d, Color color, double d2, Color color2) {
        this.addStripe(d, color);
        this.addStripe(d2, color2);
    }

    @Override
    boolean acceptIndexType(int n) {
        return n == 1 || n == 2;
    }

    @Override
    public int getColor(double d) {
        int n = this._stripes.size();
        if (n < 2) {
            if (n == 1) {
                return this._colors.elementAt(0).getRGB();
            }
            return this._defaultColor;
        }
        if (d < this._stripes.elementAt(0)) {
            return this._colors.elementAt(0).getRGB();
        }
        if (d > this._stripes.elementAt(n - 1)) {
            return this._colors.elementAt(n - 1).getRGB();
        }
        int n2 = 0;
        int n3 = 0;
        for (int i = 1; i < n; ++i) {
            if (!(d < this._stripes.elementAt(i))) continue;
            n2 = i - 1;
            n3 = i;
            break;
        }
        if (n3 == 0) {
            n2 = n - 2;
            n3 = n - 1;
        }
        return this.interpolateColors(n2, n3, d);
    }

    @Override
    public int getColor(int n) {
        return this.getColor((double)n);
    }

    public void addStripe(double d, Color color) {
        int n = 0;
        int n2 = this._stripes.size();
        if (color == null) {
            color = new Color(this._defaultColor);
        }
        for (int i = 0; i < n2; ++i) {
            if (d < this._stripes.elementAt(i)) {
                n = i;
                break;
            }
            if (i != n2 - 1) continue;
            n = n2;
        }
        this._stripes.add(n, d);
        this._colors.add(n, color);
    }

    public void removeStripe(int n) {
        int n2 = this._stripes.size();
        if (n < 0) {
            return;
        }
        if (n >= n2) {
            return;
        }
        this._stripes.remove(n);
        this._colors.remove(n);
    }

    protected int interpolateColors(int n, int n2, double d) {
        Color color = this._colors.elementAt(n);
        Color color2 = this._colors.elementAt(n2);
        double d2 = this._stripes.elementAt(n);
        double d3 = this._stripes.elementAt(n2);
        double d4 = (d - d2) / (d3 - d2);
        int n3 = (int)((double)color2.getRed() * d4 + (double)color.getRed() * (1.0 - d4));
        int n4 = (int)((double)color2.getGreen() * d4 + (double)color.getGreen() * (1.0 - d4));
        int n5 = (int)((double)color2.getBlue() * d4 + (double)color.getBlue() * (1.0 - d4));
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > 255) {
            n3 = 255;
        }
        if (n4 < 0) {
            n4 = 0;
        } else if (n4 > 255) {
            n4 = 255;
        }
        if (n5 < 0) {
            n5 = 0;
        } else if (n5 > 255) {
            n5 = 255;
        }
        return new Color(n3, n4, n5).getRGB();
    }

    protected void printStripes() {
        System.out.println();
        for (int i = 0; i < this._stripes.size(); ++i) {
            System.out.println("Stripe: " + i + "  Valor: " + this._stripes.elementAt(i) + "  Cor: " + this._colors.elementAt(i));
        }
    }
}

