/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.core.graphics;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.image.BufferedImage;
import org.apache.log4j.Logger;
import org.tecgraf.jtdk.core.swig.TeProjection;

public abstract class TdkNativeCanvas
extends Canvas {
    private static Logger _logger = Logger.getLogger(TdkNativeCanvas.class);
    protected long _cPointer = 0L;
    private static boolean _jawtLoaded = false;

    protected native long connect();

    private native void disconnect(long var1);

    protected void disconnect() {
        this.disconnect(this._cPointer);
        this._cPointer = 0L;
    }

    protected long getNativeCanvasCPtr() {
        return this._cPointer;
    }

    public boolean bindToNativeObject() {
        if (!_jawtLoaded) {
            System.loadLibrary("jawt");
            _jawtLoaded = true;
        }
        this._cPointer = this.connect();
        return this.isConnectedToNativeCanvas();
    }

    public boolean isConnectedToNativeCanvas() {
        return this._cPointer != 0L;
    }

    protected void finalize() throws Throwable {
        this.disconnect();
    }

    protected native void nativeRefresh(long var1);

    protected void refresh() {
        this.nativeRefresh(this._cPointer);
    }

    protected native void nativeResize(long var1, double var3, double var5, double var7, double var9);

    protected native void nativeSetWindow(long var1, double var3, double var5, double var7, double var9);

    protected native void nativeSetViewPort(long var1, double var3, double var5, double var7, double var9);

    protected native void nativeSetBackground(long var1, int var3, int var4, int var5);

    protected native BufferedImage nativeGetImage(long var1);

    @Override
    public void setBackground(Color color) {
        if (this._cPointer != 0L) {
            this.nativeSetBackground(this._cPointer, color.getRed(), color.getGreen(), color.getBlue());
        }
        super.setBackground(color);
    }

    protected native void nativeClear(long var1);

    protected native double nativeGetScale(long var1);

    public double getScale() {
        return this.nativeGetScale(this._cPointer);
    }

    native void nativeSetViewProjection(long var1, TeProjection var3);

    public void setViewProjection(TeProjection teProjection) {
        this.nativeSetViewProjection(this._cPointer, teProjection);
    }

    native boolean nativeHandleChanged(long var1);

    public boolean handleChanged() {
        return this.nativeHandleChanged(this._cPointer);
    }

    native boolean nativeUsingOpenGL(long var1);

    public boolean usingOpenGL() {
        return this.nativeUsingOpenGL(this._cPointer);
    }

    protected native void nativePutImage(long var1, BufferedImage var3);

    public void putImage(BufferedImage bufferedImage) {
        this.nativePutImage(this._cPointer, bufferedImage);
    }

    protected native void nativeCopyBackToFrontBuffer(long var1);

    public void copyBackToFrontBuffer() {
        this.nativeCopyBackToFrontBuffer(this._cPointer);
    }
}

