/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.core.model;

import com.vividsolutions.jts.geom.Envelope;
import java.util.Vector;
import org.tecgraf.jtdk.core.model.TeText;

public class TeTextSet {
    protected Vector<TeText> _texts = new Vector();
    protected Envelope _box = new Envelope(0.0, 0.0, 0.0, 0.0);

    public void add(TeText teText) {
        this._texts.add(teText);
        this._box.expandToInclude(teText.getBox());
    }

    public void erase(TeText teText) {
        this._texts.removeElement(teText);
        this._box = new Envelope();
        for (int i = 0; i < this._texts.size(); ++i) {
            this._box.expandToInclude(this._texts.get((int)i)._box);
        }
    }

    public void erase(int n) {
        this._texts.removeElementAt(n);
        this._box = new Envelope();
        for (int i = 0; i < this._texts.size(); ++i) {
            this._box.expandToInclude(this._texts.get((int)n)._box);
        }
    }

    public boolean empty() {
        return this._texts.size() == 0;
    }

    public TeText get(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this._texts.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this._texts.get(n);
    }

    public TeText first() {
        if (this.empty()) {
            return null;
        }
        return this._texts.get(0);
    }

    public TeText last() {
        if (this.empty()) {
            return null;
        }
        return this._texts.get(this._texts.size() - 1);
    }

    public int size() {
        return this._texts.size();
    }

    public void clear() {
        this._texts.clear();
        this._box = new Envelope(0.0, 0.0, 0.0, 0.0);
    }

    public boolean equals(TeTextSet teTextSet) {
        if (teTextSet.size() != this.size()) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < this.size(); ++i) {
            bl = bl && this.get(i).equals(teTextSet.get(i));
        }
        bl = bl && this._box.equals((Object)teTextSet._box);
        return bl;
    }

    public Object clone() {
        TeTextSet teTextSet = new TeTextSet();
        for (int i = 0; i < this.size(); ++i) {
            teTextSet.add((TeText)this.get(i).clone());
        }
        return teTextSet;
    }
}

