/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.core.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.Vector;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.tecgraf.jtdk.core.utils.DBFException;
import org.tecgraf.jtdk.core.utils.DBFFieldMetadata;
import org.tecgraf.jtdk.core.utils.DBFRecord;

public class DBF {
    private DbaseFileReader dbf;

    public DBF(String string) throws DBFException {
        try {
            File file = new File(string);
            if (!file.exists()) {
                throw new DBFException("File not found: " + string);
            }
            FileChannel fileChannel = new FileInputStream(string).getChannel();
            this.dbf = new DbaseFileReader((ReadableByteChannel)fileChannel, false, Charset.forName("ISO-8859-1"));
        }
        catch (Exception exception) {
            throw new DBFException(exception);
        }
    }

    public DBFFieldMetadata[] getMetadata() {
        int n = this.dbf.getHeader().getNumFields();
        DBFFieldMetadata[] dBFFieldMetadataArray = new DBFFieldMetadata[n];
        for (int i = 0; i < n; ++i) {
            dBFFieldMetadataArray[i] = new DBFFieldMetadata(this.dbf.getHeader().getFieldName(i), this.dbf.getHeader().getFieldType(i), i);
        }
        return dBFFieldMetadataArray;
    }

    public int getNumRecords() {
        return this.dbf.getHeader().getNumRecords();
    }

    public int getNumColumns() {
        return this.dbf.getHeader().getNumFields();
    }

    public boolean hasNext() {
        return this.dbf.hasNext();
    }

    public DBFRecord getNextRecord() throws DBFException {
        if (!this.hasNext()) {
            throw new DBFException("Row out of bounds");
        }
        try {
            DbaseFileReader.Row row = this.dbf.readRow();
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < this.dbf.getHeader().getNumFields(); ++i) {
                String string = row.read(i).toString();
                if (this.dbf.getHeader().getFieldType(i) == 'N') {
                    try {
                        Double.parseDouble(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        string = "0";
                    }
                }
                vector.add(string.trim());
            }
            return new DBFRecord(vector);
        }
        catch (Exception exception) {
            throw new DBFException(exception);
        }
    }

    public void closeDbfFile() throws IOException {
        this.dbf.close();
    }
}

