/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.application.test.buttons;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;

final class ButtonHelper {
    private final Dimension dimension = new Dimension();

    private ButtonHelper() {
    }

    public static void paintPressedBorder(Graphics graphics, Component component) {
        if (!component.isEnabled()) {
            return;
        }
        ButtonHelper.paintPressedBorder(graphics, 0, 0, component.getWidth(), component.getHeight());
    }

    public static void paintPressedBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        Color color2 = UIManager.getDefaults().getColor("control");
        graphics.setColor(color2.darker().darker());
        graphics.drawLine(n, n2, n3 - 2, n2);
        graphics.drawLine(n, n2, n, n4 - 2);
        graphics.setColor(color2.brighter());
        graphics.drawLine(n, n4 - 1, n3 - 1, n4 - 1);
        graphics.drawLine(n3 - 1, n2, n3 - 1, n4 - 1);
        graphics.setColor(color);
    }

    public static void paintHoverBorder(Graphics graphics, Component component) {
        if (!component.isEnabled()) {
            return;
        }
        ButtonHelper.paintHoverBorder(graphics, 0, 0, component.getWidth(), component.getHeight());
    }

    public static void paintHoverBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = graphics.getColor();
        Color color2 = UIManager.getDefaults().getColor("control");
        graphics.setColor(color2.brighter());
        graphics.drawLine(n, n2, n3 - 2, n2);
        graphics.drawLine(n, n2, n, n4 - 2);
        graphics.setColor(color2.darker().darker());
        graphics.drawLine(n, n4 - 1, n3 - 1, n4 - 1);
        graphics.drawLine(n3 - 1, n2, n3 - 1, n4 - 1);
        graphics.setColor(color);
    }

    public static MouseHandler createMouseHandler(Component component) {
        return new MouseHandler(component);
    }

    static final class MouseHandler
    extends MouseInputAdapter {
        private Component component;
        private Point point = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
        private boolean mouseIn;

        public MouseHandler(Component component) {
            if (component == null) {
                throw new NullPointerException();
            }
            this.component = component;
            this.setMouseIn(false);
        }

        public Point getPoint() {
            return this.point;
        }

        private void setMouseIn(boolean bl) {
            if (this.mouseIn == bl) {
                return;
            }
            this.mouseIn = bl;
            this.component.repaint();
        }

        public boolean isMouseIn() {
            return this.mouseIn;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.point = mouseEvent.getPoint();
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.setMouseIn(true);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.setMouseIn(false);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Container container = this.component.getParent();
            Point point = SwingUtilities.convertPoint(this.component, mouseEvent.getPoint(), container);
            Component component = SwingUtilities.getDeepestComponentAt(container, point.x, point.y);
            if (this.component != component) {
                this.setMouseIn(false);
            }
        }

        public void reset() {
            this.setMouseIn(false);
        }
    }
}

