/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.jtdk.desktop.application.test.buttons;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import org.tecgraf.jtdk.desktop.application.test.buttons.ButtonHelper;

public final class ToggleButton
extends JToggleButton {
    private static final long serialVersionUID = 5156393640084069245L;
    private static final Insets INSETS = new Insets(1, 1, 1, 1);
    private Dimension size;
    private ButtonHelper.MouseHandler mouseHandler;

    public ToggleButton(Action action) {
        super(action);
        this.init();
    }

    public ToggleButton() {
        this.init();
    }

    public ToggleButton(Icon icon) {
        super(icon);
        this.init();
    }

    private void init() {
        this.size = new Dimension(23, 22);
        this.setBorderPainted(false);
        this.setContentAreaFilled(true);
        this.setFocusable(false);
        this.mouseHandler = ButtonHelper.createMouseHandler(this);
        this.addMouseListener(this.mouseHandler);
        this.addMouseMotionListener(this.mouseHandler);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.getModel().isSelected()) {
            super.paintComponent(graphics);
            ButtonHelper.paintPressedBorder(graphics, this);
        } else {
            boolean bl = this.getModel().isPressed();
            boolean bl2 = this.mouseHandler.isMouseIn();
            if (bl2 && bl) {
                ButtonHelper.paintPressedBorder(graphics, this);
            }
            super.paintComponent(graphics);
            if (bl2 && !bl) {
                ButtonHelper.paintHoverBorder(graphics, this);
            }
        }
    }

    @Override
    public Insets getInsets() {
        return INSETS;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.size;
    }

    public void setLocalSize(Dimension dimension) {
        this.size = dimension;
    }
}

