/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.loadbalancer;

import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.guerlab.loadbalancer.AbstractLoadBalancer;
import net.guerlab.loadbalancer.TargetWrapper;

public class RoundRobinLoadBalancer<T, C>
extends AbstractLoadBalancer<T, C> {
    private final Lock lock = new ReentrantLock();
    private int position = 0;

    public RoundRobinLoadBalancer() {
    }

    public RoundRobinLoadBalancer(List<TargetWrapper<T>> targetList) {
        super(targetList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected T choose0(List<TargetWrapper<T>> activeTargetList, C chooseReferenceObject) {
        int size = activeTargetList.size();
        this.lock.lock();
        try {
            if (this.position >= size) {
                this.position = 0;
            }
            TargetWrapper<T> wrapper = activeTargetList.get(this.position);
            ++this.position;
            T t = wrapper == null ? null : (T)wrapper.getTarget();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }
}

