/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.databinding;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.validation.Schema;
import org.apache.cxf.Bus;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.databinding.AegisDatabinding;
import org.apache.cxf.aegis.databinding.XMLStreamDataReader;
import org.apache.cxf.aegis.type.Type;
import org.apache.cxf.aegis.type.TypeUtil;
import org.apache.cxf.aegis.xml.MessageWriter;
import org.apache.cxf.aegis.xml.stax.ElementWriter;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataBindingValidation2;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.StaxValidationManager;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.ws.commons.schema.XmlSchemaElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLStreamDataWriter
implements DataWriter<XMLStreamWriter>,
DataBindingValidation2 {
    private static final Logger LOG = LogUtils.getL7dLogger(XMLStreamDataReader.class);
    private AegisDatabinding databinding;
    private Collection<Attachment> attachments;
    private Map<String, Object> properties;
    private ServiceInfo validationServiceInfo;
    private Bus bus;

    public XMLStreamDataWriter(AegisDatabinding databinding, Bus bus) {
        this.databinding = databinding;
        this.bus = bus;
    }

    @Override
    public void setAttachments(Collection<Attachment> attachments) {
        this.attachments = attachments;
    }

    @Override
    public void setSchema(Schema s) {
    }

    @Override
    public void write(Object obj, MessagePartInfo part, XMLStreamWriter output) {
        StaxValidationManager mgr;
        Type type = this.databinding.getType(part);
        if (type == null) {
            type = this.databinding.getTypeFromClass(obj.getClass());
        }
        if (type == null) {
            throw new Fault(new Message("NO_MESSAGE_FOR_PART", LOG, part));
        }
        if (this.validationServiceInfo != null && (mgr = this.bus.getExtension(StaxValidationManager.class)) != null) {
            try {
                mgr.setupValidation(output, this.validationServiceInfo);
            }
            catch (XMLStreamException e) {
                throw new Fault(e);
            }
        }
        Context context = new Context(this.databinding.getAegisContext());
        context.setAttachments(this.attachments);
        type = TypeUtil.getWriteType(this.databinding.getAegisContext(), obj, type);
        try {
            if (obj == null) {
                if (part.getXmlSchema() instanceof XmlSchemaElement && ((XmlSchemaElement)part.getXmlSchema()).getMinOccurs() == 0L) {
                    return;
                }
                if (type.isNillable() && type.isWriteOuter()) {
                    ElementWriter writer = new ElementWriter(output);
                    MessageWriter w2 = writer.getElementWriter(part.getConcreteName());
                    w2.writeXsiNil();
                    w2.close();
                    return;
                }
            }
            ElementWriter writer = new ElementWriter(output);
            MessageWriter w2 = writer.getElementWriter(part != null ? part.getConcreteName() : type.getSchemaType());
            type.writeObject(obj, w2, context);
            w2.close();
        }
        catch (DatabindingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(Object obj, XMLStreamWriter output) {
        this.write(obj, (MessagePartInfo)null, output);
    }

    @Override
    public void setProperty(String prop, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(prop, value);
    }

    public Object getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }

    @Override
    public void setValidationServiceModel(ServiceInfo serviceInfo) {
        this.validationServiceInfo = serviceInfo;
    }
}

