/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.service.invoker;

import java.util.Collection;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.service.invoker.Factory;
import org.apache.cxf.service.invoker.PerRequestFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PooledFactory
implements Factory {
    BlockingQueue<Object> pool;
    Factory factory;
    int count;
    int max;
    boolean createMore;

    public PooledFactory(Class svcClass, int max) {
        this(new PerRequestFactory(svcClass), max, false);
    }

    public PooledFactory(Factory factory, int max) {
        this(factory, max, false);
    }

    public PooledFactory(Factory factory, int max, boolean createMore) {
        this.factory = factory;
        if (max < 1) {
            max = 16;
        }
        this.pool = new ArrayBlockingQueue<Object>(max, true);
        this.max = max;
        this.count = 0;
        this.createMore = createMore;
    }

    public PooledFactory(Collection<Object> objs) {
        this.pool = new ArrayBlockingQueue<Object>(objs.size(), true);
        this.pool.addAll(objs);
    }

    @Override
    public Object create(Exchange ex) throws Throwable {
        if (this.factory == null || this.count >= this.max && !this.createMore) {
            return this.pool.take();
        }
        Object o = this.pool.poll();
        if (o == null) {
            return this.createObject(ex);
        }
        return o;
    }

    protected synchronized Object createObject(Exchange e) throws Throwable {
        if (this.factory == null || this.count >= this.max && !this.createMore) {
            return this.pool.take();
        }
        ++this.count;
        return this.factory.create(e);
    }

    @Override
    public void release(Exchange ex, Object o) {
        this.pool.offer(o);
    }
}

